#include "global.h"
#include "wo.h"
#include "user.h"	// USER_TYPE
#include "bullet.h"

#include "net.h"
#include "app.h"	// playSound


const WClass Bullet::wclass(BULLET_TYPE, "Bullet", NULL, Bullet::replicator);
const uint8_t Bullet::props = BULLET_PROPS;


void Bullet::updateTime(time_t sec, time_t usec, float *lasting)
{
  if (move.sec == 0) {
    *lasting = move.ttl -= BULLET_LASTING;
    move.sec = sec;
    move.usec = usec;
    return;
  }

  *lasting = diffTime(sec, usec);
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl;
    stopImposedMovement();

    /* the bullet has spent its time to live => destroyed */
    //notice("%s destroyed", name.instance_name);
    toDelete();	// delete Wobject
  }
}

void Bullet::changePosition(float lasting)
{
  pos.x += lasting * move.lspeed.v[0];
  pos.y += lasting * move.lspeed.v[1];
  pos.z += lasting * move.lspeed.v[2];
}

bool Bullet::isMoving()
{
  return (move.ttl > 0.0005);
}

Bullet::Bullet(WObject *pu, void *data, time_t sec, time_t usec)
{
  /* position */
  pos.x = pu->pos.x;	//BAD + move.lspeed.v[0] * 0.2;
  pos.y = pu->pos.y;	//BAD + move.lspeed.v[1] * 0.2;
  pos.z = pu->pos.z + 0.3 * USER_DEFAULTHEIGHT;
  pos.az = pu->pos.az;

  /* geometry */
  char geom[80];
  sprintf(geom,"solid=\"sphere,radius=%f,emission=%s\"", BULLET_RADIUS, BULLET_COLOR);
  parseGeometry(geom);

  /* local creation */
  type = BULLET_TYPE;
  enableBehavior(COLLIDE_ONCE);
  initializeObject(LIST_MOBILE);
  setMaxLasting(BULLET_LASTING);
  lspeed = BULLET_SPEED;

  /* network creation */
  createVolatileNetObject(props);
  noh->declareObjCreation();

  /* action */
  move.lspeed.v[0] = lspeed * Cos(pu->pos.az);
  move.lspeed.v[1] = lspeed * Sin(pu->pos.az);
  enablePermanentMovement();
  initImposedMovement(BULLET_TTL);
}

/* Creation: this method is invisible, called by user */
void bulletCreateByUser(User *pu, void *data, time_t sec, time_t usec)
{
  new Bullet(pu, data, sec, usec);
  App::playSound(DRIPSND);
}

/* Replication from the network */
WObject * Bullet::replicator(uint8_t type_id, NetObjectId noid, Payload *pp)
{
  return new Bullet(type_id, noid, pp);
}

Bullet::Bullet(uint8_t type_id, NetObjectId _noid, Payload *pp)
{
  setType(type_id);

  replicateVolatileNetObject(props, _noid);
  noh->getAllProperties(pp);
  copyNetObjectId(_noid);

  char geom[128];
  sprintf(geom, "solid=\"sphere,radius=%f,emission=%s\"", BULLET_RADIUS, BULLET_COLOR);
  parseGeometry(geom);

  initializeObject(LIST_MOBILE);

  lspeed = BULLET_SPEED;
  initBB(pos);

  //pd initImposedMovement(BULLET_TTL);

  App::playSound(DRIPSND);
}

void get_hit(Bullet *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;

  pp->getPayload("c", &(pcur->hit));
  // pp->dumpPayload(stdout);

  if (pcur->hit == 1) {
    pcur->hit = 0;
    notice("%s hits me", pcur->name.instance_name);
    App::playSound(OUILLESND);
  }
  pcur->updateObject(oldpos);
}

/* Updates to the network */
bool Bullet::updateToNetwork(const Pos &oldpos)
{
  bool change = false;

  if ((pos.x != oldpos.x) || (pos.y != oldpos.y)) {
    noh->declareObjDelta(BULLET_PROPXY);
    change = true;
  }
  if (ABSF(pos.z - oldpos.z) > BULLET_DELTAZ)
    change = true;
  if (pos.az != oldpos.az)
    change = true;
#if 0 //not used
  if (hit != pold->hit) {
    noh->declareObjDelta(BULLET_PROPHIT);
    trace(DBG_FORCE, "bulletUpdateToNetwork: hit=%d", hit);
    change = true;
  }
#endif
  return change;
}

void Bullet::whenIntersect(WObject *pcur, WObject *pold)
{
  switch (pcur->type) {
  case USER_TYPE:
    /* bullet intersects an user in movement: hit */
    notice("%s hit by %s", pcur->name.instance_name, name.instance_name);
    pold->copyPositionAndBB(pcur);
    break;
  default:
    pold->copyPositionAndBB(pcur);
  }
  toDelete();	// delete Wobject
}

void Bullet::whenWallIntersect(WObject *pold, V3 *norm)
{
  enableBehavior(COLLIDE_ONCE);
  wallIntersect(pold, norm);
}

void bulletInitFuncList(void)
{
  getPropertyFunc[BULLET_PROPXY][BULLET_TYPE].pf = WO_PAYLOAD get_xy;
  getPropertyFunc[BULLET_PROPZ][BULLET_TYPE].pf = WO_PAYLOAD get_z;
  getPropertyFunc[BULLET_PROPAZ][BULLET_TYPE].pf = WO_PAYLOAD get_az;
  getPropertyFunc[BULLET_PROPHNAME][BULLET_TYPE].pf = WO_PAYLOAD get_hname;
  getPropertyFunc[BULLET_PROPHIT][BULLET_TYPE].pf = WO_PAYLOAD get_hit;

  putPropertyFunc[BULLET_PROPXY][BULLET_TYPE].pf = WO_PAYLOAD put_xy;
  putPropertyFunc[BULLET_PROPZ][BULLET_TYPE].pf = WO_PAYLOAD put_z;
  putPropertyFunc[BULLET_PROPAZ][BULLET_TYPE].pf = WO_PAYLOAD put_az;
  putPropertyFunc[BULLET_PROPHNAME][BULLET_TYPE].pf = WO_PAYLOAD put_hname;
  putPropertyFunc[BULLET_PROPHIT][BULLET_TYPE].pf = WO_PAYLOAD bulletPutHit; // user

  setActionFunc(BULLET_TYPE, BULLET_CREAT, WO_ACTION bulletCreateByUser, "");
}
