#ifndef BOOK_H
#define BOOK_H

#define BOOK_TYPE	43
#define BOOK_NAME	"Book"
#define BOOK_INIT	bookInitFuncList
#define BOOK_LASTING	0.07	// 70 ms
#define BOOK_PROPS	4

#define BOOK_PROPHNAME	0
#define BOOK_PROPXY	1
#define BOOK_PROPZ	2
#define BOOK_PROPAZ	3

#define BOOK_OPENED	0
#define BOOK_CLOSED_R	1
#define BOOK_CLOSED_L   2 

/* actions */
#define BOOK_OPEN    	0
#define BOOK_CLOSE      1
#define BOOK_PULL       2
#define BOOK_NEXT       3
#define BOOK_PREVIOUS   4
#define BOOK_FFWD       5
#define BOOK_REWIND     6
#define BOOK_LOOKL      7
#define BOOK_LOOKR      8

#define BOOK_DEF_TEX	"/net/vreng/jpg/paper.jpg"


/**
 * Book Class
 */
class Book: public WObject {
 public:
  static const uint8_t props;
  class Sheet *rightSide;
  class Sheet *leftSide;
  class Sheet *mobileSheet;

  float aright;		///< right angle when book is opened
  float aleft;		///< left  angle when book is opened
  float aspeed;		///< angular speed
  float v;              ///< to increase speed when sheet is turning
  float sheetThickness;	///< sheet thickness
  float sheetWidth;	///< sheet width

  uint8_t status;	///< opened | closed_r | closed_l 
  uint8_t nbSheets;	///< number of sheets
  uint8_t currentSheet;	///< current sheet number
  int stillToTurn;	///< pages to turn for p+10
  int stillToTurn2;	///< pages to turn for p-10

  char sheetsUrl[64];	///< page url
  char **texTab;	///< texture table
  char **htmlTab;	///< html table

  static const uint8_t propCount;
  static const WClass wclass;	///< class variable
  virtual const WClass* getWClass() {return &wclass;};

  Book(char *l);

  static WObject * (creator)(char *l);
  virtual bool isMoving();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual bool updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void forward(void*, time_t, time_t);
  virtual void backward(void*, time_t, time_t);
  virtual void quit();
};

void BOOK_INIT(void);

#endif // BOOK_H
