#include "global.h"
#include "wo.h"
#include "world.h"	// worlds
#include "user.h"	// USER_TYPE
#include "aoi.h"

#include "net.h"	// NetObject
#include "vgl.h"	// Solid
#include "gui.h"	// GuiRemoveUser
#include "channel.h"	// cnt_fd

#define DBG_AOI DBG_13	// temporary


const WClass Aoi::wclass(AOI_TYPE, "Aoi", Aoi::creator);

/**
 * Intersection with AoI object must be manage by VREng general intersection
 * procedure (see col.c).  That's why AoI does not need any 
 * "whenIntersect" function.  Therefore, the procedure initAoiFuncList 
 * below sets this member to NULL.  The main reason for this is that AoI
 * are objects we want to be able to go through. The only event we are 
 * interested in is when a collision occurs.
 */

Aoi * currentAoi;	// Points to current AoI we're in


/* creation from file */
WObject * Aoi::creator(char *l)
{
  return new Aoi(l);
}

Aoi::Aoi(char *l)
{
  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  l = parseChannel(l, chan);

  /* AoI are not visible */
#define AOI_VISIBLE	// to be uncommented if hard debugging time
#ifndef AOI_VISIBLE
  enableBehavior(INVISIBLE);
#endif

  initializeObject(LIST_STILL);

  currentAoi = NULL;
} 

/**
 * Performs action to be done while entering a new Area of Interest:
 */
void Aoi::aoiEnter()
{
  trace(DBG_AOI, "aoiEnter: world=%s:%s worlds=%p", worlds->name, this->chan), worlds;
  notice("Avatar \"%s\" enters in %s:%s",
	  worlds->plocaluser->name.instance_name, worlds->name, this->chan);
  char * avatarname = strdup(worlds->plocaluser->name.instance_name);
  
  /* quit current World or AoI (network shutdown) */
  aoiQuit();

  sprintf(worlds->plocaluser->name.given_name, "%s", avatarname);
  free(avatarname);

  /* new AoI is the current one */
  currentAoi = this;

  /* initializes network with new AoI's mcast group (cf. channel.cc) */
  Channel *pchan = new Channel();

  int *tabfd;
  if (pchan->createChannel(currentAoi->chan, &tabfd) <= 0) {
    error("aoiEnter: create channel failed");
    delete pchan;
    return;
  }

  /* initializes local user's avatar */
  worlds->plocaluser->initializeObject(LIST_MOBILE);
  worlds->plocaluser->noh->createNetObject(NET_VOLATILE);

  /* publishes to other VREng processes we are there (no latency) */
  worlds->plocaluser->noh->declareObjCreation();

  /* To do here: broadcast a query on new AoI to see who is there with
   * minimal latency.  In the current solution, we discover
   * other mobile objets in the new AoI only thanks to heart beats,
   * which may be quite long for AoI uses (however it may be
   * ok when entering a World).
   */

  /* GUI stuff */
  GuiUpdateUser(worlds->plocaluser);

  /* 3D stuff */
  worlds->plocaluser->update3D();
  worlds->plocaluser->updateCamera();

  //pd worlds->plocaluser->stopImposedMovement();
}

/**
 * Performs actions to be done while leaving an Area of Interest:
 */
void Aoi::aoiQuit()
{
  /* freeing only mobile object we're responsible for */
  for (ObjectList *pl = mobileList; pl; ) {
    ObjectList *next = pl->next; // handling next obj while freeing list

    /* skipping local user object (as we do not want to remove it) */
    if (pl->pobject == worlds->plocaluser) {
      pl = next;
      continue;
    }
    /* deletes mobile object from grid */
    pl->pobject->deleteObjectFromGrid();

    /* closes 3D */
    delete pl->pobject->soh;
    pl->pobject->soh = NULL;

    /* closes GUI */
    if (pl->pobject->type == USER_TYPE)
      GuiRemoveUser((User *)pl->pobject);

    /* closes network object */
    if (pl->pobject->noh) {
      if (! pl->pobject->isPermanent())
        pl->pobject->noh->declareDeletion();
      delete pl->pobject->noh;
      pl->pobject->noh = NULL;
    }

    /* performs some clean up */
    delete pl->pobject;
    pl->pobject = NULL;
    delete pl;

    pl = next;
  }
  mobileList = NULL;	// don't comment else segfault

  /* explicit declaration to network so that there is minimal latency
     on other VREng processes to see user leaving previous AoI */
  worlds->plocaluser->noh->declareDeletion();
  worlds->plocaluser->noh->deleteNetObjectFromList();

  /* closes multicast channel now as we do not need it anymore */
  //pd Channel::getCurrentChannel()->quitChannel();
  delete Channel::getCurrentChannel();		// delete Channel
}
