#ifndef ANIM_H
#define ANIM_H

#define ANIM_TYPE	13
#define ANIM_NAME	"Animator"
#define ANIM_INIT	animInitFuncList
#define ANIM_LASTING	MAXFLOAT
#define ANIM_PROPS	3

#define ANIM_PROPFRAME    0
#define ANIM_PROPNBFRAMES 1
#define ANIM_PROPTTL	  2

#define ANIM_INACTIVE	0
#define ANIM_ACTIVE	1

/**
 * Anim Class
 */
class Anim: public WObject {
 public:
  uint8_t state;	///< state anim y/n
  uint8_t frame;	///< current frame number
  uint8_t nb_frames;	///< number of frames
  float  ttl;		///< time to live

  static const WClass wclass;	///< class variable
  static const uint8_t props;	///< number of properties
  virtual const WClass* getWClass() {return &wclass;};

  Anim(char *l);

  static WObject * (creator)(char *l);

  virtual bool isMoving();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual bool updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void quit();
};

void ANIM_INIT(void);

#endif // ANIM_H
