#include "global.h"
#include "wo.h"
#include "anim.h"

#include "net.h"	// NetObject
#include "vgl.h"	// setSolidFrame


const WClass Anim::wclass(ANIM_TYPE, "Animator", Anim::creator);
const uint8_t Anim::props = ANIM_PROPS;

static uint16_t oid = 0;


WObject * Anim::creator(char *l)
{
  return new Anim(l);
}

Anim::Anim(char *l)
{
  frame = state = 0;
  ttl = 0.;

  l = parseObject(l);
  l = parsePosition(l);
  l = parseGeometry(l);
  while (l) {
    if (!strncmp(l, "anim", 4))
      l = parseUInt8(l, &state, "anim");
    else if (!strncmp(l, "frames", 6))
      l = parseUInt8(l, &nb_frames, "frames");
    else if (!strncmp(l, "begin", 5))
      l = parseUInt8(l, &frame, "begin");
    else if (!strncmp(l, "ttl", 3))
      l = parseFloat(l, &ttl, "ttl");
  }
  frame %= nb_frames;

  initializeObject(LIST_MOBILE);
  createPermanentNetObject(props, ++oid);

  if (state == ANIM_ACTIVE)
    enableImposedMovement();
} 

/* update to the network */
bool Anim::updateToNetwork(const Pos &oldpos)
{
  bool change = false;
#if 0 //pdnet
  Anim *poldanim = dynamic_cast<Anim *>(pold);
  if (! poldanim)
    return false;
  
  if (frame != poldanim->frame) {
    noh->declareObjDelta(ANIM_PROPFRAME);
    change = true;
  }
#undef CHANGENBFRAMES
#ifdef CHANGENBFRAMES
  if (nb_frames != poldanim->nb_frames) {
    noh->declareObjDelta(ANIM_PROPNBFRAMES);
    change = true;
  }
#endif
#undef CHANGEANIMTTL
#ifdef CHANGEANIMTTL
  if (ttl != poldanim->ttl) {
    noh->declareObjDelta(ANIM_PROPTTL);
    change = true;
  }
#endif
#endif //pdnet
  return change;
}

void animStart(Anim *po, void *d, time_t s, time_t u)
{
  po->move.sec = s;
  po->move.usec = u;
  po->state = ANIM_ACTIVE;
}

void animStop(Anim *po, void *d, time_t s, time_t u)
{
  po->state = ANIM_INACTIVE;
}

/* object intersects: stop */
void Anim::whenIntersect(WObject *pcur, WObject *pold)
{
  pold->copyPositionAndBB(pcur);
}

bool Anim::isMoving()
{
  return state;
}

void Anim::updateTime(time_t sec, time_t usec, float *lasting)
{
  *lasting = diffTime(sec, usec);
  if (*lasting > ttl) {
    move.sec = sec;
    move.usec = usec;
  }
}

void Anim::changePosition(float lasting)
{
  if (lasting > ttl) {
    frame = (frame + 1) % nb_frames;
    soh->setSolidFrame(frame);
  }
}

void get_frame(Anim *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;
  
  pp->getPayload("d", &(pcur->frame));
  pcur->soh->setSolidFrame(pcur->frame);
  pcur->updateObject(oldpos);
}

void put_frame(Anim *po, Payload *pp)
{
  pp->putPayload("d", po->frame);
}

void get_nb_frames(Anim *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;
  
  pp->getPayload("d", &(pcur->nb_frames));
  pcur->updateObject(oldpos);
}

void put_nb_frames(Anim *po, Payload *pp)
{
  pp->putPayload("d", po->nb_frames);
}

void get_ttl(Anim *pcur, Payload *pp)
{
  Pos oldpos = pcur->pos;
  
  pp->getPayload("f", &(pcur->ttl));
  pcur->updateObject(oldpos);
}

void put_ttl(Anim *po, Payload *pp)
{
  pp->putPayload("f", po->ttl);
}

void Anim::quit()
{
  oid = 0;
}

void animInitFuncList(void)
{
  getPropertyFunc[ANIM_PROPFRAME][ANIM_TYPE].pf = WO_PAYLOAD get_frame;
  getPropertyFunc[ANIM_PROPNBFRAMES][ANIM_TYPE].pf = WO_PAYLOAD get_nb_frames;
  getPropertyFunc[ANIM_PROPTTL][ANIM_TYPE].pf = WO_PAYLOAD get_ttl;

  putPropertyFunc[ANIM_PROPFRAME][ANIM_TYPE].pf = WO_PAYLOAD put_frame;
  putPropertyFunc[ANIM_PROPNBFRAMES][ANIM_TYPE].pf = WO_PAYLOAD put_nb_frames;
  putPropertyFunc[ANIM_PROPTTL][ANIM_TYPE].pf = WO_PAYLOAD put_ttl;

  setActionFunc(ANIM_TYPE, 0, WO_ACTION animStart, "Start");
  setActionFunc(ANIM_TYPE, 1, WO_ACTION animStop, "Stop");
}
