/*
 *  xpm.cc : glue with the XPM library.
 *  VREng Project [2002]
 *  Author: Philippe Dax
 *
 *  (C) 1997-2003 Philippe Dax @ ENST Paris
 *
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 */

#include "global.h"
#include "images.h"
#include <X11/xpm.h>


Image * loadXPM(void *texc, ImageReader read_func)
{
#if HAVE_LIBXPM
  char filename[MAXHOSTNAMELEN];

  ImgReader *ir = new ImgReader(texc, read_func);
  TextureCacheEntry *tc = (TextureCacheEntry *) texc;

  if (ir->downloadInCache(tc->texurl, filename, 1) == NULL) {
    delete ir;
    return NULL;
  }

  Image *image = NULL;

#if 0 //tbd
  XpmImage xpmimage;

  int status = XpmReadFileToXpmImage(filename, &xpmimage, NULL);
  if (status != XpmSuccess) {
    if (status == XpmColorFailed)
      error("XpmReadFileToXpmImage: bad color");
    delete ir;
    return NULL;
  }
//#if 1
  image = new Image(xpmimage.width, xpmimage.height, IMAGE_RGB, IMAGE_FIX);

#if 0
  for (int i=0; i<image->xsize * image->ysize; i++)
    image->pixmap[i] = (uint8_t) xpmimage.data[i];
  //pd image->pixmap = (uint8_t *) xpmimage.data;

  XpmFreeXpmImage(&xpmimage);	// get rid of the xpmimage
  ir->unlinkInTmp(filename);
  delete ir;

  return image;
#endif

//#else
  /* now look up the colors in the image and put them in the pic colormap */
  for (int i=0; i<(int)xpmimage.ncolors; i++) {
    char *c = (xpmimage.colorTable + i)->c_color;
    if (c == NULL || *c == '\0') {      /* use white for null color */
      c = "white";
      printf("white used for *NULL color\n");
    }
    //if (XParseColor(tool_d, tool_cm, c, &exact_def) == 0) {
    //  printf("Error parsing color %s\n",c);
    //  exact_def.red = exact_def.green = exact_def.blue = 65535;
    //}
    //pic->cmap[i].red = exact_def.red >> 8;
    //pic->cmap[i].green = exact_def.green >> 8;
    //pic->cmap[i].blue = exact_def.blue >> 8;
  }
  //pic->subtype = T_PIC_XPM;
  //pic->numcols = xpmimage.ncolors;
  //pic->pixmap = None;
  //pic->bitmap = (unsigned char *) malloc(xpmimage.width*xpmimage.height*sizeof(unsigned char));
  //if (pic->bitmap == NULL) {
  //  printf("cannot allocate space for XPM image\n");
  //  return NULL;
  //}
  for (int i=0; i<(int)(xpmimage.width*xpmimage.height); i++)
    //pic->bitmap[i] = (unsigned char) xpmimage.data[i]; /* int to unsigned char */
    image->pixmap[i] = (unsigned char) xpmimage.data[i]; /* int to unsigned char */
  //pic->hw_ratio = (float) xpmimage.height / xpmimage.width;
  //pic->bit_size.x = xpmimage.width;
  //pic->size_x = xpmimage.width * scale;
  //pic->bit_size.y = xpmimage.height;
  //pic->size_y = xpmimage.height * scale;
  XpmFreeXpmImage(&xpmimage);        /* get rid of the xpmimage */
  /* if monochrome display map bitmap */
  //if (tool_cells <= 2 || appres.monochrome)
  //  map_to_mono(pic);
#endif //tbd

  ir->unlinkInTmp(filename);
  delete ir;

  return image;
//#endif

#else
  return NULL;
#endif
}
