/* Copyright (c) Mark J. Kilgard, 1997. */

/* This program is freely distributable without licensing fees  and is
   provided without guarantee or warrantee expressed or  implied. This
   program is -not- in the public domain. */

#ifndef TXF_H
#define TXF_H

#define TXF_FORMAT_BYTE		0
#define TXF_FORMAT_BITMAP	1

typedef struct {
  uint16_t short c;	// Potentially support 16-bit glyphs
  uint8_t width;
  uint8_t height;
  signed char xoffset;
  signed char yoffset;
  signed char advance;
  char dummy;		// Space holder for alignment reasons
  short x;
  short y;
} TexGlyphInfo;

typedef struct {
  GLfloat t0[2];
  GLshort v0[2];
  GLfloat t1[2];
  GLshort v1[2];
  GLfloat t2[2];
  GLshort v2[2];
  GLfloat t3[2];
  GLshort v3[2];
  GLfloat advance;
} TexGlyphVertexInfo;

typedef struct {
  GLuint texobj;
  int tex_width;
  int tex_height;
  int max_ascent;
  int max_descent;
  int num_glyphs;
  int min_glyph;
  int range;
  uint8_t *teximage;
  TexGlyphInfo *tgi;
  TexGlyphVertexInfo *tgvi;
  TexGlyphVertexInfo **lut;
} TexFont;


extern const char *txfErrorString(void);

void txfUnloadFont(TexFont *txf);
GLuint txfEstablishTexture(TexFont *txf, GLuint texobj, GLboolean setupMipmaps);
void txfBindFontTexture(TexFont *txf);
void txfGetStringMetrics(TexFont *txf, char *string, int len, int *width, int *max_ascent, int *max_descent);
void txfRenderString(TexFont *txf, const char *string, int len);


/*
 * ENST: VREng specific
 */

TexFont * loadTxf(const char *url);

typedef struct _TexfontCacheEntry {
  int  num;
  char url[URL_LEN];
  TexFont *txf;
  struct _TexfontCacheEntry *next;
} TexfontCacheEntry;

void initTexfontCache(void);
TexFont * getTexfontFromCache(const char *url);
int getCurrentTexfontNumber(void);
TexfontCacheEntry * getTexfontEntryByUrl(const char *url);
TexfontCacheEntry * getTexfontEntryByNumber(const int);
class Http;
void txfFontHttpReader(void *atxf, Http *http);

#endif // TXF_H
