#include "global.h"
#include "images.h"


Image * loadPPM(void *texc, ImageReader read_func)
{
  ImgReader *ir = new ImgReader(texc, read_func);

  /* we read the header */
  int xsize, ysize;
  char magic[2];

  ir->get_ch();
  magic[0] = ir->ch;
  ir->get_ch();
  magic[1] = ir->ch;
  if (magic[0] != 'P' || magic[1] != '6')
    return NULL;
  ir->get_ch1();
  ir->skip_spaces();
  xsize = ir->get_int();
  ir->skip_spaces();
  ysize = ir->get_int();
  ir->skip_spaces();
  ir->get_int();	// maxval
  if (!isspace(ir->ch))
    return NULL;

  Image *image = new Image(xsize, ysize, IMAGE_RGB, IMAGE_FIX);

  /* we read the data */
  for (int y=0; y < ysize; y++)
    read_func(texc, (char *)image->pixmap + y*xsize*IMAGE_RGB, xsize*IMAGE_RGB);

  delete ir;
  return image;
}
