/* GiMd2Viewer - Quake2 model viewer
 * Copyright (C) 1998  Lionel ULMER <bbrox@mygale.org>
 *
 * Based on code Copyright (C) 1997 Trey Harrison <trey@crack.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MD2_H
#define MD2_H

typedef struct {
  float x, y, z;
  float nx, ny, xz;
} Vertex;

typedef struct {
  float s, t;
} TexInfo;

typedef struct {
  char name[16];
  Vertex *vert_table;
} Frame;

typedef struct {
  float x, y, z;
} Vec3;

typedef struct {
  uint8_t x;
  uint8_t y;		// X,Y,Z coordinate, packed on 0-255
  uint8_t z;
  uint8_t lightnormalindex; /* index of the vertex normal */
} Trivertex;

typedef struct {
  Vec3 scale;          // multiply byte verts by this
  Vec3 origin;         // then add this
  char name[16];       // frame name from grabbing
  Trivertex verts[1];  // variable sized
} FrameInfo;

typedef struct {
  char ident[4];
  int32_t version;
  int32_t skinwidth;
  int32_t skinheight;
  int32_t framesize;    // byte size of each frame
  int32_t num_skins;
  int32_t num_xyz;
  int32_t num_st;       // greater than num_xyz for seams
  int32_t num_tris;
  int32_t num_glcmds;   // dwords in strip/fan command list
  int32_t num_frames;
  int32_t ofs_skins;    // each skin is a MAX_SKINNAME string
  int32_t ofs_st;       // byte offset from start for stverts
  int32_t ofs_tris;     // offset for dtriangles
  int32_t ofs_frames;   // offset for first frame
  int32_t ofs_glcmds;
  int32_t ofs_end;      // end of file
} Md2Header;

/**
 * Md2 Class
 */
class Md2 {
 private:
  int32_t *glcmds;	// GL commands
  TexInfo *texinfo;	// texture infos
  Frame *frames;

 public:
  int32_t numframes;	// number of frames
  int32_t skinwidth;
  int32_t skinheight;

  Md2();
  virtual ~Md2();

  virtual int getDlistMd2Model(const int frame, int const nextfrm, const float inter, const float scale);
  virtual void drawMd2Model(int32_t frame, int32_t nextfrm, const float ratio, const float scale);
  virtual int32_t getGLCmds(Md2Header *md2_hdr, Http *http);
  virtual int getFrames(Md2Header *md2_hdr, Http *http);

  static Md2 * loadMd2Model(const char *url);
};

#endif  // MD2_H
