#ifndef LWO_H
#define LWO_H

#define LW_MAX_NAME_LEN 500

typedef struct {
  char name[LW_MAX_NAME_LEN];
  GLfloat r,g,b,alpha;
} lwMaterial;

typedef struct {
  int material;		// material of this face
  int index_cnt;	// number of vertices
  int *index;		// index to vertex
  float *texcoord;	// u,v texture coordinates
} lwFace;

typedef struct {
  int face_cnt;
  lwFace *face;
  int material_cnt;
  lwMaterial *material;
  int vertex_cnt;
  GLfloat *vertex;
} lwObject;

class Http;
void	lwoHttpReader(void *alwo, Http *http);
void	lw_object_free(lwObject *lw_object);
void	lw_object_show(const lwObject *lw_object);
GLfloat	lw_object_radius(const lwObject *lw_object);
void	lw_object_scale(lwObject *lw_object, GLfloat scale);

#endif // LWO_H
