#ifndef LANDMARK_H
#define LANDMARK_H

#define LM_GRID_WIDTH   20
#define LM_GRID_DEPTH   20
#define LM_GRID_HEIGHT  20

#define LM_AXIS_LENGTH  5
#define LM_GRID_SLICE   5

#define LM_SCROLL_MAX   100
#define LM_SCROLL_INCR  1

#define BEHAVIOR_STICK  0
#define BEHAVIOR_FOLLOW 1
#define BEHAVIOR_SFOLLOW 2

class UMenu;
class UEvent;
class UScrollbar;

/**
 * Landmark Class
 *
 * 3D help to visualize, displays axis and grids 2D/3D
 */
class Landmark {

 public:

  Landmark();
  /**< Constructor */

  virtual void render();
  virtual void init();
  virtual class UDialog* dialog();

  static class UDialog* buildDialog();
  /**< Builds a dialog window */

  static Landmark * getLandmark();
  /**< Returns landmark instance */

  static bool isCounterVisible();
  /**< Checks if counter is visible */

 private:
  virtual void toggleCounterVisible();
  virtual void toggleAxisVisible();
  virtual void toggleGridVisible();
  virtual void toggleOverlap();
  virtual void toggleBehavior(const int new_behavior);
  virtual void toggleGrid3d();
  virtual void setWidth(UEvent &v);
  virtual void setHeight(UEvent &v);
  virtual void setDepth(UEvent &v);
  virtual void setRed(UEvent &v);
  virtual void setGreen(UEvent &v);
  virtual void setBlue(UEvent &v);
  virtual void setPosX(UEvent &v);
  virtual void setPosY(UEvent &v);
  virtual void setPosZ(UEvent &v);
  virtual void setRotX(UEvent &v);
  virtual void setRotY(UEvent &v);
  virtual void setRotZ(UEvent &v);

  int landmark_lists;	///< gl list
  float glmat[16];	///< default matrix projection

  float posx;
  float posy;
  float posz;
  float rotx;
  float roty;
  float rotz;
  int grid_width, grid_depth, grid_height;
  float grid_red, grid_green, grid_blue, grid_alpha;
  int grid_visible, axis_visible, behavior, overlap, grid_3d;

  UScrollbar *s_width, *s_height, *s_depth, *s_red, *s_green, *s_blue,
             *s_x, *s_y, *s_z, *s_rotx, *s_roty, *s_rotz;

  void draw();
  void drawGrid();
  void drawAxis();
  void displayGrid();
  void displayAxis();

  void defaultValue();
  void genScrollbar();
};

#endif // LANDMARK_H
