// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //

#include "global.h"
#include "boneVertex.h"
#include "boneLink.h"


Vertex::Vertex()
{
  link  = NULL;
  links = 0;
  linkListCompiled = 0;
  initialNormal.reset();
  currentNormal.reset();
  u = -1.;
  v = -1.;
}

Vertex::Vertex(Vect3D &zePosition)
{
  initialPosition = zePosition;
  currentPosition = zePosition;

  link  = NULL;
  links = 0;
  linkListCompiled = 0;
  initialNormal.reset();
  currentNormal.reset();
  u = -1.;
  v = -1.;
}

Vertex::Vertex(Vect3D *zePosition)
{
  initialPosition = *zePosition;
  currentPosition = *zePosition;

  link  = NULL;
  links = 0;
  linkListCompiled = 0;

  initialNormal.reset();
  currentNormal.reset();
  u = -1.;
  v = -1.;
}

Vertex::Vertex(float ox, float oy, float oz)
{
  initialPosition.setValue(ox, oy, oz);
  currentPosition.setValue(ox, oy, oz);

  link  = NULL;
  links = 0;
  linkListCompiled = 0;
  initialNormal.reset();
  currentNormal.reset();
  u = -1.;
  v = -1.;
}

void Vertex::setPosition(Vect3D &zePosition)
{
  initialPosition =  zePosition;
  currentPosition =  zePosition;
}

void Vertex::setPosition(Vect3D *zePosition)
{
  initialPosition = *zePosition;
  currentPosition = *zePosition;
}

void Vertex::addLink(LINK *zeLink)
{
  linkList.addElement(zeLink);
  linkListCompiled = 0;
}

void Vertex::removeLink(LINK *zeLink)
{
  linkList.removeElement(zeLink);
  linkListCompiled = 0;
}

void Vertex::compileLinkList()
{
  link = linkList.getNiceTable(&links);
  linkListCompiled = 1;
}
