// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //
#ifndef BONEVERT_H
#define BONEVERT_H

#include "boneName.h"
#include "boneVect3d.h"
#include "boneList.h"
#include "boneIO.h"

class LINK;

//------------------------------------------------
// This class represents the extremity of a bone
// So a bone is made of one of this class (that
// contains translation/rotation) and a reference
// to it's father ( the extremity it depends of )
// This extremity also has several children whom
// he'll be the father ( see that like a tree )

class BoneVertex : public Nameable {
 public:

  // Datas in the bone vertex class

  // -> Position at the begining
  Vect3D initialPosition;
  float  initialAngle;
  Vect3D initialAxis;

  // -> Position during the animation
  Vect3D currentPosition;
  float  currentAngle;
  Vect3D currentAxis;

  // -> Children management
  LIST < BoneVertex > childList;
  BoneVertex ** child;
  BoneVertex *  father;
  int           children;
  int           childListCompiled;

  // -> Links management
  // (a link is defined by a bone vertex, a vertex of the mesh and a weight)
  LIST < LINK > linkList;
  LINK ** link;
  int     links;
  int     linkListCompiled;

  // -> Saves of the matrices
  float initialMatrix[16];
  float initialMatrixInverted[16];
  float currentMatrix[16];
  // -> Same for rotation matrices (may be used for normal computations)
  float initialRotMatrix[16];
  float initialRotMatrixInverted[16];
  float currentRotMatrix[16];

  // -> a field to scale the influence of this boneVertex
  float influenceScaleFactor;

  // -> a field to tell if this boneVertex should animated or not
  int animated;

  // Construct / destruct
  BoneVertex();
  BoneVertex(Vect3D & zePosition, float zeAngle, Vect3D & zeAxis);
  BoneVertex(Vect3D * zePosition, float zeAngle, Vect3D * zeAxis);
  virtual ~BoneVertex();

  // Accessing initial position datas
  void setInitialPosition(Vect3D & zePosition);
  void setInitialPosition(Vect3D * zePosition);
  void setInitialPosition(float ox, float oy, float oz);
  void setInitialRotation(float zeAngle, Vect3D & zeAxis);
  void setInitialRotation(float zeAngle, Vect3D * zeAxis);
  void setInitialRotation(float zeAngle, float axisx, float axisy, float axisz);

  // Accessing current position datas ( during animation)
  void setCurrentPosition(Vect3D & zePosition);
  void setCurrentPosition(Vect3D * zePosition);
  void setCurrentPosition(float ox, float oy, float oz);
  void setCurrentRotation(float zeAngle, Vect3D & zeAxis);
  void setCurrentRotation(float zeAngle, Vect3D * zeAxis);
  void setCurrentRotation(float zeAngle, float axisx, float axisy, float axisz);

  // Accessing current position datas ( during animation)
  // with relative values (realtive to initial position)
  void resetCurrentPosition(void);
  void resetCurrentRotation(void);
  void translateCurrentPosition(Vect3D & delta);
  void translateCurrentPosition(Vect3D * delta);
  void translateCurrentPosition(float dx, float dy, float dz);
  void scaleCurrentPosition(float scalex, float scaley, float scalez);
  void scaleCurrentPosition(float scale);

  // Actions on this node and its children
  // Those actions are definitives
  void scale(float sx, float sy, float sz);

  // Children list managing
  void setFather(BoneVertex *zeFather);
  void addChild(BoneVertex *newChild);
  void removeChild(const char *zeName);
  BoneVertex *findChild(const char *zeName);

  // Link list managing
  void addLink(LINK *zeLink);
  void removeLink(LINK *zeLink);

  // Intern functions to compile the lists... should be private maybe ?
  void compileChildList();
  void compileLinkList();
  void generateInitialMatrix(); // needs glPush / glPop and glLoadIdentity at the begining
  void generateCurrentMatrix(); // needs glPush / glPop and glLoadIdentity at the begining

  // I/O functions
  void read(char *filename, float size = 1.);
  void write(char *filename);
  void readFromFile(FILE *file, float size = 1.);
  void writeToFile(FILE *file);
  void print(int cpt = 0, FILE *dest = stderr);

};

#endif // BONEVERT_H
