// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //

#ifndef BONEVECT3D_H
#define BONEVECT3D_H


class Vect3D {
 public:

//----------------------------
// Champs de la classe vect3d
float x,y,z;

//-----------------------------
// Constructeurs / destructeur
inline Vect3D(float ox = 0. , float oy = 0. , float oz = 0.)
{
  x = ox;
  y = oy;
  z = oz;
}

inline Vect3D(Vect3D & op)
{
  x = op.x;
  y = op.y;
  z = op.z;
}

inline Vect3D(Vect3D * op)
{
  x = op->x;
  y = op->y;
  z = op->z;
}

virtual ~Vect3D() {}

//------------------------
// Actions sur les champs
inline void setValue(float ox, float oy, float oz)
{
  x = ox;
  y = oy;
  z = oz;
}

inline void reset()
{
  x = 0.;
  y = 0.;
  z = 0.;
}

//---------------------------
// Fonction sur les vecteurs
inline float length()
{
  return (float) sqrt(x*x + y*y + z*z);
}

inline void normalize()
{
  float len = length();
  if (len != 0.) {
    float invLen = 1. / len;
    x *= invLen;
    y *= invLen;
    z *= invLen;
  }
}

//------------
// Operateurs
// -> Addition
inline friend Vect3D operator + (Vect3D & op1, Vect3D & op2)
{
  Vect3D result;
  result.x = op1.x + op2.x;
  result.y = op1.y + op2.y;
  result.z = op1.z + op2.z;
  return result;
}
inline void operator += (Vect3D & op)
{
  x += op.x;
  y += op.y;
  z += op.z;
}
// -> Soustraction
inline friend Vect3D operator - (Vect3D & op1, Vect3D & op2)
{
  Vect3D result;
  result.x = op1.x - op2.x;
  result.y = op1.y - op2.y;
  result.z = op1.z - op2.z;
  return result;
}
inline void operator -= (Vect3D & op)
{
  x -= op.x;
  y -= op.y;
  z -= op.z;
}
// -> Mise a l'echelle
friend Vect3D operator * (Vect3D & op1, float op2)
{
  Vect3D result;
  result.x = op1.x * op2;
  result.y = op1.y * op2;
  result.z = op1.z * op2;
  return result;
}
inline void operator *= (float op)
{
  x *= op;
  y *= op;
  z *= op;
}
// -> Mise a l'echelle
inline friend Vect3D operator * (float op1, Vect3D & op2)
{
  Vect3D result;
  result.x = op1 * op2.x;
  result.y = op1 * op2.y;
  result.z = op1 * op2.z;
  return result;
}
inline void operator *= (Vect3D & op)
{
  x *= op.x;
  y *= op.y;
  z *= op.z;
}
// -> Multiplication matricielle
inline friend Vect3D operator * (float * mat, Vect3D & vect)
{
  Vect3D result;
  result.x = vect.x * mat[ 0] + vect.y * mat[ 4] + vect.z * mat[ 8] + mat[12];
  result.y = vect.x * mat[ 1] + vect.y * mat[ 5] + vect.z * mat[ 9] + mat[13];
  result.z = vect.x * mat[ 2] + vect.y * mat[ 6] + vect.z * mat[10] + mat[14];
  return result;
}
inline void operator *= (float * mat)
{
  float tx = x;
  float ty = y;
  float tz = z;
  x = tx * mat[ 0] + ty * mat[ 4] + tz * mat[ 8] + mat[12];
  y = tx * mat[ 1] + ty * mat[ 5] + tz * mat[ 9] + mat[13];
  z = tx * mat[ 2] + ty * mat[ 6] + tz * mat[10] + mat[14];
}
// -> Mise a l'echelle par division ( sans doute peu utile )
inline friend Vect3D operator / (Vect3D & op1, float op2)
{
  Vect3D result;
  float inv = 1. / op2;
  result.x = op1.x * inv;
  result.y = op1.y * inv;
  result.z = op1.z * inv;
  return result;
}
inline void operator / (float op)
{
  float inv = 1. / op;
  x *= inv;
  y *= inv;
  z *= inv;
}

//-------------------
// Methodes avancees
// -> Produit scalaire
static inline float dotProduct(Vect3D & op1, Vect3D & op2)
{
  return op1.x * op2.x + op1.y * op2.y + op1.z * op2.z;
}

static inline float dotProduct(Vect3D * op1, Vect3D * op2)
{
  return op1->x * op2->x + op1->y * op2->y + op1->z * op2->z;
}
// -> Produit vectoriel
inline void crossProduct(Vect3D & op1, Vect3D & op2)
{
  x = op1.y * op2.z - op1.z * op2.y;
  y = op1.z * op2.x - op1.x * op2.z;
  z = op1.x * op2.y - op1.y * op2.x;
}

inline void crossProduct(Vect3D * op1, Vect3D * op2)
{
  x = op1->y * op2->z - op1->z * op2->y;
  y = op1->z * op2->x - op1->x * op2->z;
  z = op1->x * op2->y - op1->y * op2->x;
}
};

#endif // BONEVECT3D_H
