// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //

#ifndef BONEMESH3D_H
#define BONEMESH3D_H

#include "boneName.h"
#include "boneVertex.h"
#include "boneTriangle.h"
#include "boneLink.h"
#include "boneList.h"

class Mesh3D : public Nameable {
 public:

  // Champs de la classe mesh3d

  // -> Gestion des sommets
  LIST < Vertex > vertexList;
  Vertex       ** vertex;
  int             vertices;
  int             vertexListCompiled;

  // -> Gestion des faces triangulaires
  LIST < TRIANGLE > triangleList;
  TRIANGLE       ** triangle;
  int               triangles;
  int               triangleListCompiled;

  //---------------------------
  // Infos de boite englobante
  float minx,miny,minz;
  float maxx,maxy,maxz;

  //-----------------------------
  // Constructeurs / destructeur
  Mesh3D();
  virtual ~Mesh3D();

  //------------------------
  // Actions sur les champs
  virtual void addVertex(Vect3D & zePosition);
  virtual void addVertex(Vect3D * zePosition);
  virtual void addVertex(float ox, float oy, float oz);
  virtual void addTriangle(int index1, int index2, int index3);
  virtual void generateBoundingBox();

  //----------------------
  // Modification du mesh
  virtual void rebuildNormals();
  virtual void flipNormals();

  virtual void mirrorx();
  virtual void mirrory();
  virtual void mirrorz();
  virtual void scale    (float sx, float sy, float sz); // Definitive action !
  virtual void translate(float dx, float dy, float dz); // Definitive action !

  virtual void planarMappingX();
  virtual void planarMappingY();
  virtual void planarMappingZ();
  virtual void cylinderMapping();

  virtual void projectLight();

  //--------------------
  // Fonctions internes
  void compileVertexList();
  void compileTriangleList();
};

#endif // BONEMESH3D_H
