// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //

#ifndef BONELINK_H
#define BONELINK_H

#include "boneVertex.h"
#include "boneVert.h"

class LINK {
 public:

// Champs de la classe link
Vertex *vertex;
BoneVertex *boneVertex;
float weight;

// Constructeurs / destructeur
LINK(Vertex *zeVertex = NULL, BoneVertex *zeBoneVertex = NULL, float zeWeight = 0.) 
{
  vertex        = NULL;
  boneVertex    = NULL;
  setVertex     (zeVertex);
  setBoneVertex (zeBoneVertex);
  setWeight     (zeWeight);
}

virtual ~LINK()
{
  if (vertex     != NULL) vertex    ->removeLink(this);
  if (boneVertex != NULL) boneVertex->removeLink(this);
}

inline void setVertex(Vertex *zeVertex)
{
  if (vertex != NULL) vertex->removeLink(this);
  vertex = zeVertex;
}

inline void setBoneVertex(BoneVertex *zeBoneVertex)
{
  if (boneVertex != NULL) boneVertex->removeLink(this);
  boneVertex = zeBoneVertex;
}

inline void notifyTarget()
{
  if (vertex     != NULL) vertex->addLink(this);
  if (boneVertex != NULL) boneVertex->addLink(this);
}

inline void setWeight(float zeWeight)
{
  weight = zeWeight;
}
};

#endif // BONELINK_H
