// ------------------------------------------------------------ //
// Author   : This file has been written by Yann Renard         //
// Copyright: This file is totaly free and you may distribute   //
//            it to anyone you want, without modifying this     //
//            header. If you use it in a commercial project (?) //
//            or in bigger project (!), I would be glad to know //
//            about it :) Please mail me...                     //
//            be glad to know about it, please mail me          //
//                myself_yr@hotmail.com                         //
// ------------------------------------------------------------ //

//-----------------------------------------------------
// This is the main class that is to animate the bones
// and the 3d mesh correctly... It creates the link
// bettween the different vertices and bones and
// calculates the new position each time you ask

// Typical use of this class :
//   myBoneAnimator.registerMesh ( oneMesh );
//   myBoneAnimator.registerSkeleton ( oneSkeleton );
//   myBoneAnimator.compileLinkList ();
//   ... in loop ...
//     change skeleton current pos
//   myBoneAnimator.animate ();
//   myBoneAnimator.render ();
//   ... end loop ...

#ifndef BONEANIMATOR_H
#define BONEANIMATOR_H

#include "boneList.h"
#include "boneMesh3d.h"
#include "boneLink.h"
#include "boneVert.h"

class BoneAnimator {
 public:

  /* What we'll animate */
  Mesh3D *meshToMove;
  BoneVertex *skeleton;

  /* Links management */
  LIST < LINK > linkList;
  LINK       ** link;
  int           links;
  int           linkListCompiled;

  // Construct / destruct
  BoneAnimator();
  virtual ~BoneAnimator();

  // Accessing datas
  virtual void registerMesh(Mesh3D *zeMesh);
  virtual void registerSkeleton(BoneVertex *zeRoot);

  // Operations on both mesh and skeleton
  virtual void scale(float sx, float sy, float sz);

  // List compilation
  virtual void compileLinkList();
  virtual void emptyLinkList();
  virtual void generateLinkList();
  inline float getLength(Vertex *vertex, BoneVertex *node);
  inline float getWeight(Vertex *vertex, BoneVertex *node);

  // Rendering and animating the mesh and skeleton
  virtual void render();
  virtual void renderSkeletonNode(BoneVertex *node);
  virtual void animate();
  virtual void animateSkeletonNode(BoneVertex *node);

 private:
  void addNodeAndChildren(BoneVertex *boneVertex, LIST < BoneVertex > *list);
};

#endif // BONEANIMATOR_H
