#include "global.h"
#include "channel.h"	// switchChannel
#include "gui.h"	// options

/**
 * SAP packet
 */
typedef struct {
  uint32_t hdr;
  uint32_t src;
  char data[1];
} sapPkt_t;


static void sdrEnd(int status)
{
#if HAVE_LIBPTHREAD
  pthread_exit(NULL);
#else
  exit(status);
#endif
}

/** SAP/SDR listener: MBone detection */
static void * sdrListener(void *arg)
{
  int sdsdr;
  struct sockaddr_in sasdr, sasrc;

  if ((sdsdr = socketDatagram()) < 0)
    sdrEnd(1);

  sasdr.sin_family = AF_INET;
  sasdr.sin_addr.s_addr = htonl(INADDR_ANY);
  sasdr.sin_port = htons(SAP_PORT);

  if (setReuseAddr(sdsdr) < 0)
    sdrEnd(1);
  if (bind(sdsdr, (struct sockaddr *) &sasdr, sizeof(sasdr)) < 0) {
    perror("bind sdr");
    sdrEnd(1);
  }

  struct ip_mreq mreq;
  memset(&mreq, 0, sizeof(mreq));
  //pd mreq.imr_multiaddr.s_addr = inet_addr(SAP_ADDR);
  inet4_pton(SAP_ADDR, &(mreq.imr_multiaddr.s_addr));
  mreq.imr_interface.s_addr = htonl(INADDR_ANY);

  if (addMembership(sdsdr, &mreq) < 0) {
    error("sdrListener: can't membership");
    sdrEnd(1);
  }
  setNoLoopback(sdsdr);

  socklen_t len = sizeof(struct sockaddr_in);
  char bufsdr[BUFSIZ];
  memset(bufsdr, 0, BUFSIZ);

  recvfrom(sdsdr, bufsdr, sizeof(bufsdr), 0, (struct sockaddr *) &sasrc, &len);
  for (int i=8; i<12; i++)
    printf("%c", bufsdr[i]);	// print SDP version v=

#if HAVE_LIBPTHREAD
  options->reflector = false;	// no reflector needed, we are on the MBone
  //pd Channel::switchChannel();
#else
  kill(getppid(), SIGUSR1);
#endif

  sdrEnd(0);
  return (void *) NULL;
}

#if !defined(HAVE_LIBPTHREAD)
static void sdrHere(int sig)
{
  //trace(DBG_FORCE, "sdrHere: sig=%d", sig);
  signal(SIGUSR1, SIG_DFL);
  options->reflector = false;	// no reflector needed, we are on the MBone
  //pd Channel::switchChannel();
}
#endif

/** Sdr init: called by initNetwork */
void sdrInit(void)
{
#if HAVE_LIBPTHREAD
  pthread_t tid;
  pthread_create(&tid, NULL, sdrListener, (void *) NULL);
#else
  signal(SIGUSR1, sdrHere);
  if (! fork())
    sdrListener((void *) NULL);
#endif
}
