#include "global.h"
#include "world.h"	// Universe

/*
 * manage group/port/ttl strings
 */

char * getGroup(const char *chan_str, char *grp_str)
{
  // TODO
  // Call GNC (Group Name Cache)
  // return gncGroupByName(worldname, leasetime);

  trace(DBG_IPMC, "getGroup: chan_str=%s", chan_str);

  char *chanstr = strdup(chan_str);
  char *p;
  if ((p = strchr(chanstr, '/')) == NULL) {
    error("getGroup: chan_str=%s", chan_str);
    *grp_str = 0;
    free(chanstr);
    return NULL;
  }
  *p = '\0';
  strcpy(grp_str, chanstr);
  free(chanstr);
  return grp_str;
}

uint16_t getPort(const char *chan_str)
{
  uint16_t port;
  const char *p;

  if ((p = strchr(chan_str, '/')) == NULL)
    port = (uint16_t) DEF_VRE_MPORT;
  else
    port = (uint16_t) atoi(++p);
  trace(DBG_IPMC, "getPort: port=%u", port);
  return port;
}

uint8_t currentTtl(void)
{
  return universe->ttlorigin;
}

uint8_t getTtl(const char *chan_str)
{
  uint8_t ttl;
  const char *p;

  if ((p = strrchr(chan_str, '/')) == NULL)
    ttl = (uint8_t) DEF_VRE_TTL;
  else
    ttl = (uint8_t) atoi(++p);
  trace(DBG_IPMC, "getTtl: ttl=%u", ttl);
  return ttl;
}

char * createMc(char *chan_str, char *groupstr, uint16_t port, uint8_t ttl)
{
  sprintf(chan_str, "%s/%u/%d", groupstr, port, ttl);
  trace(DBG_IPMC, "createMc: chan_str=%s", chan_str);
  return chan_str;
}

char * newMc(char *chan_str)
{
  char *grpstr = NULL;
  char groupstr[GROUP_LEN];

  trace(DBG_IPMC, "newMc: chan_str=%s", chan_str);
  getGroup(chan_str, groupstr);
  grpstr = strdup(groupstr);
  createMc(chan_str, grpstr, getPort(chan_str), currentTtl());
  free(grpstr);
  trace(DBG_IPMC, "newMc: chan_str=%s", chan_str);
  return chan_str;
}

int getWorldId(const char *chan_str)
{
  char lowip;
  const char *p;
  char groupstr[GROUP_LEN];

  getGroup(chan_str, groupstr);
  if ((p = strrchr(groupstr, '.')) == NULL)
    lowip = 255;
  else
    lowip = (char) atoi(++p);
  uint16_t port = getPort(chan_str);
  return lowip * port * currentTtl();
}
