/* ==================================================== ======== ======= *
 *
 *  widgets.hh : Athena, Motif and Ubit Widgets for the VREng GUI
 *
 *  VREng Project
 *  Author: Eric Lecolinet @ ENST Paris (elc@enst.fr)
 *  Date:   (rev) 20 Sept 02
 *
 *  http://www.infres.enst.fr/net/vreng/
 *  http://www.enst.fr/~elc/ubit
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 */

#ifndef WIDGETS_HH
#define WIDGETS_HH

#define VRENG_WELCOME	"Welcome to VREng!"
#define PLEASE_WAIT	"Please Wait! Loading the Rendez-Vous World..."
#define TOOLBAR_HEIGHT	30
#define MESSAGES_HEIGHT	85
#define LIST_WIDTH	70


#if WANT_UBIT
typedef class UBox *GuiUser;
typedef class UBox *GuiWorld;
typedef class UBox *GuiCartItem; //PLD type des widgets des items du panier
#else
typedef Widget GuiUser;
typedef Widget GuiWorld;
#endif

#ifndef boolean
typedef int boolean;
#endif

/* ==================================================== ======== ======= */

/**
 * GuiWidgets Class
 */
class GuiWidgets {
  class GUI &gui;	// points to the containing GUI class

 public:

  static class WTheme theme;  // the theme used to paramaterize the GUI

  GuiWidgets(class GUI&);

  // default resource specs for X Window
  static char **getFallbackOptions();

  // adds a new message to the message box
  void writeMessage(const char *mode, const char *from, const char *mess);

  //opens alert box if arg is not null, closes it if arg is null
  void alert(const char *message);
  void resizeGLZone(int width, int height);

  class UBox * addUser(User *user);
  void updateUser(GuiUser gu, User *user);
  void removeUser(GuiUser gu);

  class UBox * addWorld(World *world, boolean isCurrentWorld);
  void updateWorld(World *world, boolean isCurrentWorld);
  void removeWorld(World *world);

  // Vnc 
  class Vnc *vnc;

  void redirectToVnc(Vnc *vnc);
  void launchVncConnect(Vnc *vnc);
  void initVncConnect(Vnc *vnc);

  // Vrelet
  class Vrelet *vrelet;
  void redirectToVrelet(Vrelet *vrelet);

  // Carrier
  class Carrier *car;

  // Cart
  GuiCartItem addCartItem(WObject *);
  void removeCartItem(GuiCartItem);
  void redirectToCarrier(class Carrier *carrier);

  // Icon
  PutInfo *put_info;
  void launchIconDisplay(class Icon *icon);

#if WANT_UBIT    // UBIT Toolkit
  class UMenu* updateObjectInfo(ObjInfo*, int mouse_button);
  /**<
   * updates object info (infobox in the toolbar and contextual info menu)
   * NB: delete the infobox and makes it disappear if button = 0
   */

  void updateCartItemInfo(WObject *po);
  ///< updates the infobox in the toolbar when a cart item is selected

  class UFrame* getFrame()     {return frame;}
  class UIncrust* getGLZone()  {return glzone;}
  class UMenu* getOpenedMenu() {return openedMenu;}
  class UDialog *vnc_dialog;
  class UDialog *puturl_dialog, *putfile_dialog, *file_dialog, *get_dialog;
  class UStr *vnc_server, *vnc_port, *vnc_passwd;

 private:

  boolean followMouseMode;
  class UFrame *frame;    // main frame of the application
  class UBox   *toolbar, *users, *worlds, *messages, *entry, 
    *worldsPane, *usersPane, *controlPanel, *cartWidget, *cartPane;
  class UDialog *alertBox; 
  class UScrollpane *messagesPane;
  class UIncrust *glzone;   //OpenGL Drawing Zone
  class UWidth   *glzoneWidth;
  class UHeight  *glzoneHeight;
  class UStr     *entryStr, *alertStr;
  // contextual info and naviguation
  class UBox     *infobox;
  class UMenu    *infoMenu, *navigMenu, *openedMenu;
  class UStr     *selected_object_url;
  // current mouse position and pressed button
  int x_ref, y_ref;
  int button;

  UBox* makeNavigator(int);
  UBox* makeControlPanel();

  void mpress(class UEvent&);
  void mrelease(class UEvent&);
  void mmove(class UEvent&);
  void mdrag(class UEvent&);
  void kpress(class UEvent&);
  void krelease(class UEvent&);

  void setMouseRef(class UEvent&);
  void startMotion(class UEvent&);
  void startMotion(class UEvent&, class Mvt* mvt1, class Mvt* mvt2);
  void stopMotion(class UEvent&);
  void motion(class UEvent&);
  void entryAction(class UEvent&);

  void processMessage(class UEvent&);

#else // ATHENA or MOTIF
 public:
  int glwin_x, glwin_y;
  void updateObjectInfo(ObjInfo *objinfo, int createMenu);

 private:
  Widget frame, glzone, users, worlds, messages, entry,
    menuBar, toolBar, moveBar, objectBar, objectMenu, rightPanel, 
    worldsPane, usersPane;

  static void glzoneMousePressEH(Widget, XtPointer, XEvent*, Boolean*);
  static void glzoneKeyPressEH(Widget, XtPointer, XEvent*, Boolean*);
  static void glzoneKeyReleaseEH(Widget, XtPointer, XEvent*, Boolean*);
  static void glzoneMouseMoveEH(Widget, XtPointer, XEvent*, Boolean*);
  static void glzoneSetFocusEH(Widget, XtPointer, XEvent*, Boolean*);
  static void entrySetFocusEH(Widget, XtPointer, XEvent*, Boolean*);
  static void entryActionEH(Widget, XtPointer, XEvent*, Boolean*);
  static void entryActionCB(Widget, XtPointer, XtPointer);
#endif
};

#endif // WIDGETS_HH
