#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
  int c;

  if (argc == 1) {
    fprintf(stderr, "usage: %s string < text > string.h\n", argv[0]);
    exit(1);
  }

  printf("const char %s[] = \"\\\n", argv[1]);
  while ((c = getchar()) != EOF) {
    if (c == '\n')
      printf("\\n\\\n");
    else if (c == '"')
      printf("\\\"");
    else
      putchar(c);
  }
  printf("\\n\\\n\";\n");
  fclose(stdout);
}
