#include "global.h"
#include "vgl.h"	// VglQuit
#include "net.h"	// NetQuit
#include "world.h"	// WoQuit

extern int my_wait(pid_t);

/* Local variable */
static int inquit;


/** quit VREng */
void quitVreng(int i)
{  
  if (inquit) {
    trace(DBG_FORCE, "quit: inquit=%d sig=%d", inquit, i);
    if (inquit > 3)
      exit(i);
    else {
      inquit++;
      exit(i);
    }
  }
  inquit++;

  /* Close modules */
  VglQuit();
  World::terminate();
  NetQuit();

  /* quit if i!=0 (to eventually call Xerrors) */
  if (i) exit(i);
}

static
void quitSig(int sig)
{
  fprintf(stderr, "Got signal %d, aborting VREng.\n", sig);
  quitVreng(sig);
}

#ifndef WIN32
static
void reapchild(int sig)
{
  my_wait(-1);
}
#endif // !WIN32

void initSignals(void)
{
#ifndef WIN32
  signal(SIGILL, quitSig);
  signal(SIGTRAP, quitSig);
  signal(SIGFPE, quitSig);
  signal(SIGBUS, quitSig);
  signal(SIGSEGV, quitSig);
  signal(SIGCHLD, reapchild);
#endif // !WIN32
}
