/* ==================================================== ======== ======= *
 *
 *  gui.h : generic public interface for the VREng GUI
 *  NOTE: this file is common to  Athena, Motif and Ubit GUIs
 *
 *  VREng Project
 *  Author: Eric Lecolinet @ ENST Paris (elc@enst.fr)
 *  Date:   July 2000
 *
 *  WWW: http://www.enst.fr/~elc  http://www.infres.enst.fr/net/vreng/
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 */

#ifndef GUI_H
#define GUI_H


/**
 * Options Class
 */
class Options {
 public:
  uint16_t width3D;
  uint16_t height3D;
  uint8_t maxsimcon;	///< max simultaneous connections
  uint32_t dbg;		///< debug mask
  uint32_t cachetime;	///< live time of the cache
  bool quality;		///< 3D quality or not
  bool flashy;		///< flashy buttons
  bool counters;	///< 2D counters in 3D
  bool reflector;	///< unicast/multicast reflector
  char *channel;	///< initial Multicast channel
  char *nick;		///< nickname
  char *url;		///< initial world url
  char *world;		///< initial world name
  char *skinf;		///< front face url
  char *skinb;		///< back face url
  char *version;	///< VREng version

  Options();
  /**< constructor */
};

extern Options *options;
/**< Options */

void quitVreng(int);
void initSignals(void);

void GuiInitAndGetOptions(int argc, char *argv[]);
void GuiMainLoop( void (*initCB)(void) );
/**< take a fct. which will be launched after the window will be opened */

void GuiAddInputTable(int table_count, int *table, int table_no);
void GuiRemoveInputTable(int table_count, int table_no);
/**< NOTE: table_no=0 for tab_fd / table_no=1 for tab_manager_fd */

int  GuiGetCycles(void);
/**< gives the current fps */

void GuiWriteMessage(const char *mode, const char *from, const char *mess);
/**< writes a message */

void GuiSetBusy(bool state);
/**< sets the 'busy' cursor */

void GuiInProgess(int progress);
/**< indicates work progress. value from 0 to 100 */

class UBox * GuiAddUser(class User *);
void GuiUpdateUser(class User *);
void GuiRemoveUser(class User *);

class UBox * GuiAddWorld(class World *world, bool isCurrent);
void GuiUpdateWorld(class World *world, bool isCurrent);
void GuiRemoveWorld(class World *world);

void GuiRedirectToVnc(class Vnc *vnc);
void GuiLaunchVncConnect(class Vnc *vnc);

void GuiRedirectToVrelet(class Vrelet *vrelet);

//PLD cart
class UBox * GuiAddCartItem(class WObject *po);
void GuiRemoveCartItem(class WObject *po, int target);
void GuiRedirectToCarrier(class Carrier *carrier);

void GuiAlert(const char *message);
/** Opens an alert box */

void GuiLaunchIconDisplay(class Icon *icon);
/** Opens a dialog box to display */

/**
 * PutInfo class
 */
class PutInfo {
 public:
  class UStr *put_url;		///< document's url
  class UStr *put_file;		///< local file
  class UStr *put_ofile;	///< public file
  class UStr *put_name;		///< document's name
  class UStr *put_icon;		///< document's icon

  PutInfo();
  /** Constructor */

  void putIcon(const class UStr& val);
  void putIcon();
  /** Puts Icon's infos */
};

#endif // GUI_H
