#ifndef TRIGO_H
#define TRIGO_H

#ifndef M_PI
#define M_PI            3.14159265
#endif
#ifndef M_PI_2
# define M_PI_2         1.57079 // pi/2
#endif
#ifndef M_PI_4
# define M_PI_4         0.78539 // pi/4
#endif
#ifndef M_1_PI
# define M_1_PI         0.31831 // 1/pi
#endif
#ifndef M_SQRT2
# define M_SQRT2        1.41421 // sqrt(2)
#endif
#ifndef M_SQRT1_2
# define M_SQRT1_2      0.70710 // 1/sqrt(2)
#endif
#ifndef M_SQRT3
# define M_SQRT3        1.73205 // sqrt(3)
#endif

#define DEGREE2RADIAN(x) ((float) (M_PI/180.0)*(x))
#define RADIAN2DEGREE(x) ((float) (180.0/M_PI)*(x))

void initTrigo(void);

float deltaAngle(float a1, float a2);
/**< Returns angular variation modulo 2PI */

int radian2degree(float);
/**< Converts radian ro degree */

float Cos(double);
float Sin(double);
float Tan(double);

#endif // TRIGO_H
