#include "global.h"


static float sintab[360];


/** Returns angular variation modulo 2PI */
float deltaAngle(float a1, float a2)
{
  float d = a1 - a2;

  d -= M_2PI * ((int)(d / M_2PI));
  return d;
}

/** Converts radian ro degree */
int radian2degree(float r)
{
  int d;

  if (r < 0)
    r += (double) M_2PI;
  d = (int) (r / (double) M_2PI * 3600);
  if (d % 10 > 5)
    d += 5;
  d /= 10;
  d %= 360;
  return d;
}

void initTrigo(void)
{
  int d;
  double r;

  for (d=0; d < 360; d++) {
    r = (float) d * (M_2PI / 360);
    sintab[d] = (float) sin(r);
  }
}

float Sin(double r)
{
  return ((float) sintab[radian2degree((float) r)]);
}

float Cos(double r)
{
  return ((float) (Sin(r + (double) M_PI/2)));
}

float Tan(double r)
{
  return ((float) (Sin(r) / Cos(r)));
}
