#include "global.h"
#include "gui.h" 	// GuiWriteMessage


const char *e_fork = "can't fork for";
const char *e_exec = "can't exec";
const char *e_tool = "unknown tool";
const char *e_not_implemented = "not implemented";
const char *e_bad_type = "bad type";

static bool infatal = false;


void fatal(const char *s,...)
{
  va_list ap;

  va_start(ap, s);
  vfprintf(stderr, s, ap);
  va_end(ap);
  fprintf(stderr, "\n");
  if (!infatal) {
    infatal = true;
    quitVreng(-1);
  }
}

void warning(const char *s,...)
{
  va_list ap;
  char buf[256];
  
  va_start(ap, s);
  if (debug) {
    vfprintf(stderr, s, ap);
    va_end(ap);
    fprintf(stderr, "\n");
  }
  vsprintf(buf, s, ap);
  GuiWriteMessage("warning", NULL, buf);
  vfprintf(stderr, s, ap);
  va_end(ap);
  fprintf(stderr, "\n");
}

void notice(const char *s,...)
{
  va_list ap;
  char buf[256];
  
  va_start(ap, s);
  vsprintf(buf, s, ap);
  va_end(ap);
  GuiWriteMessage("notice", NULL, buf);
}

void trace(int dbgmask, const char *s,...)
{
  va_list ap;

  if (debug & (1 << dbgmask) || dbgmask == DBG_FORCE) {
    va_start(ap, s);
    vfprintf(stderr, s, ap);
    va_end(ap);
    fprintf(stderr, "\n");
  }
}

void error(const char *s,...)
{
  va_list ap;

  va_start(ap, s);
  vfprintf(stderr, s, ap);
  va_end(ap);
  fprintf(stderr, "\n");
}

/** text drawing */
void gl_printf(GLfloat r, GLfloat g, GLfloat b, GLfloat a,
                GLint x, GLint y, GLuint font, const char *s, ...)
{
  va_list ap;
  char buf[128];

  va_start(ap, s);
  vsprintf(buf, s, ap);
  va_end(ap);

  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
   glLoadIdentity();
   glOrtho(0, (GLdouble) options->width3D, 0, (GLdouble) options->height3D, -1.,1.);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glColor4f(r, g, b, a);
   glRasterPos2i(x, y);
   glListBase(font);
   glCallLists(strlen(buf), GL_UNSIGNED_BYTE, buf);
   glMatrixMode(GL_PROJECTION);
  glPopMatrix();
}


FILE * writelog(const char *s,...)
{
  static FILE *fl = NULL;
  va_list ap;
  char logfile[PATH_LEN];

  if (fl == NULL) {
    sprintf(logfile, "%s/log", vrengdir);
    unlink(logfile);
    if ((fl = fopen(logfile, "w")) == NULL) {
      perror("open log");
      return (FILE *) NULL;
    }
  }
  va_start(ap, s);
  vfprintf(fl, s, ap);
  fprintf(fl, "\n");
  va_end(ap);
  return fl;
}

void closelog(FILE * fl)
{
  fclose(fl);
}

void printlog(void)
{
  FILE *fl;
  char logfile[PATH_LEN];
  char buf[256];

  sprintf(logfile, "%s/log", vrengdir);
  if ((fl = fopen(logfile, "r")) == NULL) {
    perror("open log");
    return;
  }
  while (fgets(buf, sizeof(buf), fl) != NULL)
    fputs(buf, stderr);
  closelog(fl);
}
