#ifndef FORMAT_H
#define FORMAT_H

/* file extensions */
#define EXT_GIF		"gif"
#define EXT_JPEG	"jpeg"
#define EXT_PNG		"png"
#define EXT_BMP		"bmp"
#define EXT_PPM		"ppm"
#define EXT_PGM		"pgm"
#define EXT_PCX		"pcx"
#define EXT_XPM		"xpm"
#define EXT_PHP		"php"
#define EXT_JPG		"jpg"
#define EXT_JPEG	"jpeg"
#define EXT_RGB		"rgb"
#define EXT_RGBA	"rgba"
#define EXT_BW		"bw"
#define EXT_LA		"la"
#define EXT_VRE		"vre"
#define EXT_MD2		"md2"
#define EXT_TXF		"txf"
#define EXT_HTML	"html"
#define EXT_HTM		"htm"
#define EXT_XML		"xml"
#define EXT_PDF		"pdf"
#define EXT_URL		"url"
#define EXT_TXT		"txt"
#define EXT_PS		"ps"
#define EXT_GZ		"gz"
#define EXT_DOC		"doc"
#define EXT_XLS		"xls"
#define EXT_PPT		"ppt"
#define EXT_RTF		"rtf"
#define EXT_MP2		"mp2"
#define EXT_MP3		"mp3"
#define EXT_MP4		"mp4"
#define EXT_MPG		"mpg"
#define EXT_MPEG	"mpeg"
#define EXT_MID		"mid"
#define EXT_MIDI	"midi"
#define EXT_SMIL	"smil"
#define EXT_SVG		"svg"
#define EXT_TAR		"tar"
#define EXT_TGZ		"tgz"
#define EXT_TARGZ	"tar.gz"
#define EXT_JAVA	"java"
#define EXT_JAR		"jar"
#define EXT_C		"c"
#define EXT_H		"h"
#define EXT_CC		"cc"
#define EXT_HH		"hh"
#define EXT_CPP		"cpp"
#define EXT_HPP		"hpp"
#define EXT_VRE		"vre"
#define EXT_BAP		"bap"
#define EXT_FAP		"fap"

/* MIME subtypes */
#define MIME_GIF	"gif"
#define MIME_JPEG	"jpeg"
#define MIME_PNG	"png"
#define MIME_BMP	"bmp"
#define MIME_PPM	"x-portable-pixmap"
#define MIME_PGM	"x-portable-graymap"
#define MIME_PCX	"x-pcx"
#define MIME_XPM	"x-xpixmap"
#define MIME_PHP	"x-php"
#define MIME_RGB	"x-rgb"
#define MIME_RGBA	"x-rgba"
#define MIME_LA		"x-la"
#define MIME_BW		"x-bw"
#define MIME_VRE	"x-vre"
#define MIME_MD2	"x-md2"
#define MIME_TXF	"x-txf"
#define MIME_PLAIN	"plain"

/* image paths */
#define IMG_DEF		"/net/vreng/icon/txt.gif"
#define IMG_HTML	"/net/vreng/icon/html.gif"
#define IMG_XML		"/net/vreng/icon/xml.gif"
#define IMG_URL		"/net/vreng/icon/url.gif"
#define IMG_TXT		"/net/vreng/icon/txt.gif"
#define IMG_PHP		"/net/vreng/icon/php.gif"
#define IMG_GIF		"/net/vreng/icon/gif.gif"
#define IMG_JPG		"/net/vreng/icon/jpg.gif"
#define IMG_PNG		"/net/vreng/icon/png.gif"
#define IMG_PDF		"/net/vreng/icon/pdf.gif"
#define IMG_PS		"/net/vreng/icon/ps.gif"
#define IMG_WORD	"/net/vreng/icon/word.gif"
#define IMG_XLS		"/net/vreng/icon/xls.gif"
#define IMG_PPT		"/net/vreng/icon/ppt.gif"
#define IMG_RTF		"/net/vreng/icon/rtf.gif"
#define IMG_MP3		"/net/vreng/icon/mp3.gif"
#define IMG_MPG		"/net/vreng/icon/mpg.gif"
#define IMG_MIDI	"/net/vreng/icon/midi.gif"
#define IMG_C		"/net/vreng/icon/c.gif"
#define IMG_H		"/net/vreng/icon/h.gif"
#define IMG_CPP		"/net/vreng/icon/cpp.gif"
#define IMG_SMIL	"/net/vreng/icon/smil.gif"
#define IMG_SVG		"/net/vreng/icon/svg.gif"
#define IMG_TGZ		"/net/vreng/icon/tgz.gif"

/* Loaders */
enum {
  LOADER_NULL,
  LOADER_GIF,
  LOADER_JPG,
  LOADER_PNG,
  LOADER_PPM,
  LOADER_PGM,
  LOADER_PCX,
  LOADER_BMP,
  LOADER_SGI,
  LOADER_XPM
};

/* Players */
enum {
  PLAYER_WEB,
  PLAYER_PDF,
  PLAYER_PS,
  PLAYER_OFFICE,
  PLAYER_MP3,
  PLAYER_MPG,
  PLAYER_MIDI,
  PLAYER_SMI,
  PLAYER_SVG,
  PLAYER_WGET,
  PLAYER_MP4,
  PLAYER_SWF
};

struct _imgs {
  char *ext;
  char *mime;
  uint8_t loader;
};

struct _icons {
  char *ext;
  char *img;
  uint8_t player;
};


uint8_t getLoaderByMime(const char *str);
uint8_t getLoaderByExt(char *str);
bool getExt(char *str, char *ext);
void getImgByExt(const char *str, char *img);
uint8_t getPlayerByExt(const char *str);

#endif // FORMAT_H
