#include "global.h"
#include "prefs.h"


/* globals */
char vrengdir[PATH_LEN];	// user homedir vreng path
char vrengcwd[PATH_LEN];	// where I am
char vrengprefs[PATH_LEN];	// prefs path
char vrengbookmarks[PATH_LEN];	// bookmarks path
char vrengicons[PATH_LEN];	// icons path
char vrengcache[PATH_LEN];	// cache path
char vrengpasswdfile[PATH_LEN];	// VNC password path

char systemname[9] = "unknown";
char releasename[9] = "unknown";
char machinename[32] = "unknown";

char *my_vrestr = NULL;
char *my_widthstr = NULL;
char *my_depthstr = NULL;
char *my_heightstr = NULL;
char *my_mapfrontstr = NULL;
char *my_mapbackstr = NULL;
char *my_mapleftstr = NULL;
char *my_maprightstr = NULL;
char *my_hoststr = NULL;
char *my_webstr = NULL;
char *my_modelstr = NULL;
char *my_facestr = NULL;
char *my_colorstr = NULL;
char *my_bapsstr = NULL;
char *httpproxystr = NULL;
char *noproxystr = NULL;
char *mcastproxystr = NULL;


void initsysinfo(void)
{
#if HAVE_UNAME
  struct utsname myutsname;

  uname(&myutsname);
  strcpy(systemname, myutsname.sysname);
  strcpy(releasename, myutsname.release);
  strcpy(machinename, myutsname.machine);
  for (uint32_t i=0; i < sizeof(machinename); i++) {
    if (machinename[i] == ' ')
      machinename[i] = '_';
  }
#endif
}

void initNice(void)
{
#if HAVE_NICE
  //PD nice(NZERO + 00);
  nice(0);
#endif
}

void initFloating(void)
{
#if HAVE_FPSETMASK
  fpsetmask(0L);
#endif
}

void initEnv(void)
{
  char *home;
  char pathenvdir[PATH_LEN], pathprefs[PATH_LEN], pathicons[PATH_LEN], pathbookmarks[PATH_LEN], pathcache[PATH_LEN], pathpasswdfile[PATH_LEN];
  struct stat bufstat;

  if ((home = getenv("HOME")) == NULL)
    return;
  if (getcwd(vrengcwd, sizeof(vrengcwd)) == NULL)
    return;

  sprintf(pathenvdir, "%s/.vreng", home);
  if (stat(pathenvdir, &bufstat) < 0)
    mkdir(pathenvdir, 0700);
  strcpy(vrengdir, pathenvdir);
  chdir(pathenvdir);

  sprintf(pathicons, "%s/icons", pathenvdir);
  if (stat(pathicons, &bufstat) < 0)
    mkdir(pathicons, 0700);
  strcpy(vrengicons, pathicons);

  sprintf(pathprefs, "%s/prefs", pathenvdir);
  strcpy(vrengprefs, pathprefs);

  sprintf(pathbookmarks, "%s/bookmarks", pathenvdir);
  strcpy(vrengbookmarks, pathbookmarks);

  sprintf(pathpasswdfile, "%s/vncpasswd", pathenvdir);
  strcpy(vrengpasswdfile, pathpasswdfile);

  sprintf(pathcache, "%s/cache", pathenvdir);
  if (stat(pathcache, &bufstat) < 0)
    mkdir(pathcache, 0700);
  strcpy(vrengcache, pathcache);
  chdir(vrengcwd);
}

void parsePrefs(void)
{
  FILE *fp;
  char *p1, *p2, buf[BUFSIZ];

  if ((fp = fopen(vrengprefs, "r")) == NULL) {
    if ((fp = fopen(vrengprefs, "w")) == NULL) {
      perror("create prefs");
      return;
    }
    fputs(def_prefs, fp);
    fclose(fp);
    if ((fp = fopen(vrengprefs, "r")) == NULL)
      return;
  }

  while (fgets(buf, sizeof(buf), fp)) {
    if (*buf == '#' || *buf == '\n')
      continue;
    buf[strlen(buf) - 1] = '\0';
    p1 = strtok(buf, " \t=");
    p2 = strtok(NULL, " \t#");
    if (strncmp(p1, "world", 5) == 0) {
      my_vrestr = new char[strlen(p2) + 1];
      strcpy(my_vrestr, p2);
      trace(DBG_INIT, "vre = %s", p2);
    }
    else if (strncmp(p1, "width", 5) == 0) {
      my_widthstr = new char[strlen(p2) + 1];
      strcpy(my_widthstr, p2);
      trace(DBG_INIT, "width = %s", p2);
    }
    else if (strncmp(p1, "depth", 5) == 0) {
      my_depthstr = new char[strlen(p2) + 1];
      strcpy(my_depthstr, p2);
      trace(DBG_INIT, "depth = %s", p2);
    }
    else if (strncmp(p1, "height", 6) == 0) {
      my_heightstr = new char[strlen(p2) + 1];
      strcpy(my_heightstr, p2);
      trace(DBG_INIT, "height = %s", p2);
    }
    else if (strncmp(p1, "mapfront", 8) == 0 || strncmp(p1, "mapface", 7) == 0) {
      my_mapfrontstr = new char[strlen(p2) + 1];
      strcpy(my_mapfrontstr, p2);
      trace(DBG_INIT, "mapfront = %s", p2);
    }
    else if (strncmp(p1, "mapback", 7) == 0) {
      my_mapbackstr = new char[strlen(p2) + 1];
      strcpy(my_mapbackstr, p2);
      trace(DBG_INIT, "mapback = %s", p2);
    }
    else if (strncmp(p1, "mapleft", 7) == 0) {
      my_mapleftstr = new char[strlen(p2) + 1];
      strcpy(my_mapleftstr, p2);
      trace(DBG_INIT, "mapleft = %s", p2);
    }
    else if (strncmp(p1, "mapright", 8) == 0) {
      my_maprightstr = new char[strlen(p2) + 1];
      strcpy(my_maprightstr, p2);
      trace(DBG_INIT, "mapright = %s", p2);
    }
    else if (strncmp(p1, "host", 4) == 0) {
      my_hoststr = new char[strlen(p2) + 1];
      strcpy(my_hoststr, p2);
      trace(DBG_INIT, "host = %s", p2);
    }
    else if (strncmp(p1, "web", 3) == 0) {
      my_webstr = new char[strlen(p2) + 1];
      strcpy(my_webstr, p2);
      trace(DBG_INIT, "web = %s", p2);
    }
    else if (strncmp(p1, "model", 5) == 0) {
      my_modelstr = new char[strlen(p2) + 1];
      strcpy(my_modelstr, p2);
      trace(DBG_INIT, "model = %s", p2);
    }
    else if (strncmp(p1, "face", 4) == 0) {
      my_facestr = new char[strlen(p2) + 1];
      strcpy(my_facestr, p2);
      trace(DBG_INIT, "face = %s", p2);
    }
    else if (strncmp(p1, "color", 5) == 0) {
      my_colorstr = new char[strlen(p2) + 1];
      strcpy(my_colorstr, p2);
      trace(DBG_INIT, "color = %s", p2);
    }
    else if (strncmp(p1, "baps", 4) == 0) {
      my_bapsstr = new char[strlen(p2) + 1];
      strcpy(my_bapsstr, p2);
      trace(DBG_INIT, "baps = %s", p2);
    }
    else if (strncmp(p1, "http_proxy", 10) == 0) {
      httpproxystr = new char[strlen(p2) + 1];
      strcpy(httpproxystr, p2);
      trace(DBG_INIT, "httpproxy = %s", p2);
    }
    else if (strncmp(p1, "no_proxy", 8) == 0) {
      noproxystr = new char[strlen(p2) + 1];
      strcpy(noproxystr, p2);
      trace(DBG_INIT, "noproxy = %s", p2);
    }
    else if (strncmp(p1, "mcast_proxy", 11) == 0) {
      mcastproxystr = new char[strlen(p2) + 1];
      strcpy(mcastproxystr, p2);
      trace(DBG_INIT, "mcastproxy = %s", p2);
    }
  }

  fclose(fp);
}

void cleanCache(time_t cachetime)
{
  time_t now;
  time(&now);
  chdir(vrengcache);
#if HAVE_READDIR
  DIR *dirp = opendir(".");
  if (dirp) {
    struct dirent *dp;
    struct stat bufstat;

    for (dp = readdir(dirp); dp; dp = readdir(dirp)) {
      if (stat(dp->d_name, &bufstat) == 0) {
        if (S_ISREG(bufstat.st_mode)) {
          if (now - bufstat.st_mtime > cachetime) {
            unlink(dp->d_name);
          }
        }
      }
    }
    closedir(dirp);
  }
#else
  char cmd[128];
  sprintf(cmd, "IFS=' '; /bin/rm -f *");
  system(cmd);
#endif
  chdir(vrengcwd);
}
