#include "global.h"
#include "app.h"


/* global variable */
int xtermtool = SSH_TOOL;

static pid_t xtermpid = -1;


void App::startxterm(const char *host)
{
  //trace(DBG_TOOL, "xterm: host=%s", host);
  switch (xtermpid = fork()) {
  case -1:
    error("%s xterm", e_fork);
    break;
  case 0:
    if (xtermtool == SSH_TOOL)
      execlp("xterm", "xterm", "-title", host, "-e", "ssh", host, NULL);
    if (xtermtool == TELNET_TOOL)
      execlp("xterm", "xterm", "-title", host, "-e", "telnet", host, NULL);
    error("%s xterm", e_exec);
    exit(1);
  default:
    break;
  }
}

void App::quitxterm()
{
  if (xtermpid > 0)
    kill(xtermpid, SIGKILL);
}
