#include "global.h"
#include "app.h"

#include "net.h"	// getGroup getPort


/* global variable */
int whiteboardtool = WB_TOOL;

static pid_t whiteboardpid = -1;


static void getwhiteboardmc(const char *mc, char *whiteboardmc)
{
  uint16_t port;
  char group[GROUP_LEN];

  port = getPort(mc);
  port += WHITEBOARD_INCR_PORT;
  getGroup(mc, group);
  createMc(whiteboardmc, group, port, currentTtl());
  trace(DBG_TOOL, "whiteboardmc=%s", whiteboardmc);
}

void App::startwhiteboard(const char *mc)
{
  char *p, *ttl;
  char whiteboardmc[CHAN_LEN];

  getwhiteboardmc(mc, whiteboardmc);
  p = strrchr(whiteboardmc, '/');
  *p = '\0';
  ttl = ++p;

#if defined(WIN32) && !defined(CYGWIN32) // _spawn
  if (whiteboardtool == WB_TOOL) {
    whiteboardpid = _spawnlp(_P_NOWAIT, "wb", "wb", "-C", "VREng-wb", "-t", ttl,
                           "-l", "+r", whiteboardmc, NULL);
  }
  if (whiteboardtool == WBD_TOOL) {
    whiteboardpid = _spawnlp(_P_NOWAIT, "wbd", "wbd", "-C", "VREng-wbd", "-t", ttl,
                            "-l", "+r", whiteboardmc, NULL);
  }
  if (whiteboardtool == NTE_TOOL) {
    whiteboardpid = _spawnlp(_P_NOWAIT, "nte", "nte", "-C", "VREng-nte", "-t", ttl,
                            whiteboardmc, NULL);
  }
#else // !WIN32
  switch (whiteboardpid = fork()) {
  case -1:
    error("%s whiteboard", e_fork);
    break;
  case 0:
    if (whiteboardtool == WB_TOOL) {
      execlp("wb", "wb", "-C", "VREng-wb", "-t", ttl, "-l", "+r", whiteboardmc, NULL);
      error("%s wb", e_exec);
    }
    if (whiteboardtool == WBD_TOOL) {
      execlp("wbd", "wbd", "-C", "VREng-wbd", "-t", ttl, "-l", "+r", whiteboardmc, NULL);
      error("%s wbd", e_exec);
    }
    if (whiteboardtool == NTE_TOOL) {
      execlp("nte", "nte", "-C", "VREng-nte", "-t", ttl, whiteboardmc, NULL);
      error("%s nte", e_exec);
    }
    exit(1);
  default:
    break;
  }
#endif // !WIN32
}

void App::quitwhiteboard()
{
#ifndef WIN32 // can't kill under windows
  if (whiteboardpid > 0)
    kill(whiteboardpid, SIGKILL);
#endif // !WIN32
}
