#include "global.h"
#include "http.h"	// url2cache urlAbs
#include "app.h"

extern int my_wait(pid_t);


int App::startwget(const char *_url, char *file, char options[])
{
  bool cache = false;

  char url[URL_LEN];
  urlAbs(_url, url);

  if (file && (! strcmp(options, "-qO"))) {	// use the cache
    cache = true;
    if (url2cache(_url, file) == 0)
      return 0;

    struct stat bufstat;
    if (stat(file, &bufstat) == 0) {
      trace(DBG_TOOL, "startwget: %s found in cache", file);
      if (bufstat.st_size != 0)
        return 1;	// file yet in the cache
      unlink(file);	// remove empty file
    }
    trace(DBG_TOOL, "startwget: download %s in %s", url, file);
  }

  pid_t pid;
  int status;
  bool spider = false;
  if (!strncmp(options, "--spider", 8))
    spider = true;

  switch (pid = fork()) {
  case -1:
    error("%s wget", e_fork);
    return 0;
  case 0:		// child starts transfert
    if (file == NULL)
      if (spider)
        execlp("wget", "wget", "-q", options, url, NULL);
      else
        execlp("wget", "wget", "-q", url, NULL);
    else if (! strncmp(options, "-iO", 3))		// local copy
      execlp("wget", "wget", "-i", url, "-O", file, NULL);
    else
      execlp("wget", "wget", options, file, url, NULL);
    error("%s wget", e_exec);
    exit(1);
  default:
    if (! cache && ! spider)	// not in cache
      return 1;
    status = my_wait(pid);	// parent waits end of transfert
    if (status) {
      if (! spider) {
        error("wget status=%d file=%s", status, file);
        unlink(file);	// because wget leaves an empty file
      }
      return 0;
    }
#if HAVE_UTIME
    utime(file, NULL);	// set current time
#endif
    return 1;
  }
}

int App::checkUrl(const char *url)
{
  return App::startwget(url, NULL, "--spider");
}

void App::unlinktmp(const char *file)
{
  if (access(file, W_OK) == 0)
    unlink(file);
}
