#include "global.h"
#include "app.h"


/* global variable */
int vrmltool = WEBSPACE_TOOL;

static pid_t vrmlpid = -1;


static void startwebspace(const char *name, const char *url)
{
  switch (vrmlpid = fork()) {
  case -1:
    error("%s %s", e_fork, name);
    break;
  case 0:
    execlp(name, name, url, NULL);
    error("%s %s", e_exec, name);
    exit(1);
  default:
    break;
  }
}

static void startvrweb(const char *name, const char *url)
{
  switch (vrmlpid = fork()) {
  case -1:
    error("%s %s", e_fork, name);
    break;
  case 0:
    execlp(name, name, url, NULL);
    error("%s %s", e_exec, name);
    exit(1);
  default:
    break;
  }
}

void App::startvrml(const char *url)
{
  if (vrmltool == WEBSPACE_TOOL)
    startwebspace("webspace", url);
  if (vrmltool == VRWEB_TOOL)
    startvrweb("vrweb", url);
  else
    error("%s browser", e_tool);
}

void App::quitvrml()
{
  if (vrmlpid > 0) {
    kill(vrmlpid, SIGKILL);
    vrmlpid = -1;
  }
}
