#ifndef VNCCLIENT_H
#define VNCCLIENT_H

#include "rfbproto.h"

#define RFB_BUF_SIZE	640*480

/**
 * class VNCRGB
 * this is what our framebuffer is made of 24 bits per pixel
 * 8bits for Red, 8 for Green, 8 for Blue
 */
class VNCRGB {
 public:

  VNCRGB();
  // this constructor is only used to handle faster 32bits pixels we get from the server
  VNCRGB(const CARD32 &pixel);
  VNCRGB(CARD8 red, CARD8 green, CARD8 blue);

  CARD8 Red;
  CARD8 Green;
  CARD8 Blue;
};

/**
 * class VNCClient
 * object will be used in VReng:
 * - to connect to the VNC server
 * - to handle its messages
 * - to forward pointer and keyboard events to the server
 * FrameBuffer is public
 */
class VNCClient {
 private:

  char rfbbuffer[RFB_BUF_SIZE];
  // this buffer is used to get Server MSGs

  bool ViewOnly;
  // do we want to forward events? (no if true)

  void FillRect(int rx, int ry, int rw, int rh, VNCRGB pixel);
  CARD8 RescalePixValue(CARD32 Pix, CARD8 Shift, CARD16 Max);
  VNCRGB CardToVNCRGB(CARD32 Pixel);
  // handling Rectangles we got from server

  bool HandleRAW8(int rx, int ry, int rw, int rh);
  bool HandleRAW16(int rx, int ry, int rw, int rh);
  bool HandleRAW32(int rx, int ry, int rw, int rh);
  bool HandleCR(int srcx, int srcy, int rx, int ry, int rw, int rh);
  bool HandleRRE8(int rx, int ry, int rw, int rh);
  bool HandleRRE16(int rx, int ry, int rw, int rh);
  bool HandleRRE32(int rx, int ry, int rw, int rh);
  bool HandleCoRRE8(int rx, int ry, int rw, int rh);
  bool HandleCoRRE16(int rx, int ry, int rw, int rh);
  bool HandleCoRRE32(int rx, int ry, int rw, int rh);
  bool HandleHextile8(int rx, int ry, int rw, int rh);
  bool HandleHextile16(int rx, int ry, int rw, int rh);
  bool HandleHextile32(int rx, int ry, int rw, int rh);

 protected:

  VNCRFBproto RFB_proto;
  // the VNCRFBproto object implements all we need to to send and receive
  // messages specified in the RFB protocol

 public:

  VNCClient(char *server, int port, char *passFile);
  // constructor

  char *serverCutText;
  bool newServerCutText;
  // for now, public attributes we keep to handle server cut texts

  VNCRGB *FrameBuffer;
  CARD16 framebufferWidth;
  CARD16 framebufferHeight;
  // here is our FrameBuffer

  int getSock();
  // we might want to get the socket descriptor to listen to it

  enum {BPP8, BPP16, BPP32};
  bool VNCInit();
  bool VNCInit(int flag);
  bool VNCClose();
  // set of functions to initialize the connection
  // VNCInit has to allocate memory for the framebuffer if everything goes fine
  // VNCClose has to free it
  // flag can be BPP8, BPP16 or BPP16 to indicate how many bits per pixel we want

  /* Remote Frame Buffer Protocol v3.3 */

  void SendRFBEvent(char **params, Cardinal *num_params) ;
  bool SendIncrementalFramebufferUpdateRequest();
  bool SendFramebufferUpdateRequest(int x, int y, int w, int h, bool incremental);
  // messages from client to server

  bool HandleRFBServerMessage();
  // handle the messages from the server

};

/**
 * class VNCClientTextured
 * inherits everything from VNCClient
 * the FrameBuffer allocated is bigger than the real VNC server screen size
 * and has dimensions that are a power of 2
 * needed by OpenGL to map the texture
 */
class VNCClientTextured : public VNCClient {
 public:

  VNCClientTextured(char *server, int port, char *pass);

  CARD16 realScreenWidth;
  CARD16 realScreenHeight;
  // here we keep what the real server screen size is

  bool VNCInit();
  bool VNCInit(int flag);

};

#endif // VNCCLIENT_H
