#include "global.h"
#include "app.h"

#include "net.h"	// getGroup getPort

#ifndef VIDEODEVICE
#if SOLARIS
#define VIDEODEVICE	"rtvc"
#else
#define VIDEODEVICE	"video"
#endif
#endif


/* global variable */
int videotool = VIC_TOOL;

static pid_t videopid = -1;


static void getvideomc(const char *mc, char *videomc)
{
  uint16_t port;
  char group[GROUP_LEN];

  port = getPort(mc);
  port += VIDEO_INCR_PORT;
  if (port % 1)
    port++;	// even port for RTP
  getGroup(mc, group);
  createMc(videomc, group, port, currentTtl());
  trace(DBG_TOOL, "videomc=%s", videomc);
}

void App::startvideo(const char *mc)
{
  char videomc[CHAN_LEN];
  getvideomc(mc, videomc);

#if defined(WIN32) && !defined(CYGWIN32) // _spawn
  videopid = _spawnlp(_P_NOWAIT, "vic", "vic", "-A", "rtp", "-B", "20", "-D",
                     VIDEODEVICE, "-f", "h261", "-C", "VREng-vic", videomc,
                     NULL);
#else // !WIN32
  switch (videopid = fork()) {
  case -1:
    error("%s video", e_fork);
    break;
  case 0:
    execlp("vic", "vic", "-A", "rtp", "-B", "20", "-D", VIDEODEVICE,
         "-f", "h261", "-C", "VREng-vic", videomc, NULL);
    error("%s vic", e_exec);
    exit(1);
  default:
    break;
  }
#endif // !WIN32
}

void App::quitvideo()
{
#ifndef WIN32
  if (videopid > 0)
    kill(videopid, SIGKILL);
#endif // !WIN32
}
