/*
 * INTERPPS tool
 *
 * Philippe Dax
 * Jul 1999
 */

#include "global.h"
#include "app.h"


/* global variable */
int pstool = GV_TOOL;

static pid_t pspid = -1;


static void startgv(const char *tool, const char *cacheps)
{
  switch (pspid = fork()) {
  case -1:
    error("%s %s", e_fork, tool);
    break;
  case 0:
    execlp("gv", tool, cacheps, NULL);
    execlp("ghostscript", tool, cacheps, NULL);
    error("%s %s", e_exec, tool);
    exit(1);
  default:
    break;
  }
}

void App::viewps(const char *url)
{
  //trace(DBG_TOOL, "pstool=%x url=%s", pstool, url);
  char * cacheps = new char[MAXHOSTNAMELEN];
  if (App::startwget(url, cacheps) != 0) {
    if (pstool == GV_TOOL)
      startgv("gv", cacheps);
    else if (pstool == GHOSTVIEW_TOOL)
      startgv("ghostview", cacheps);
    else
      error("%s ps", e_tool);
  }
  delete[] cacheps;
}

static void starta2ps(const char *tool, const char *cacheps)
{
  switch (pspid = fork()) {
  case -1:
    error("%s %s", e_fork, tool);
    break;
  case 0:
    execlp("a2ps", tool, "-d", cacheps, NULL);
    error("%s %s", e_exec, tool);
    exit(1);
  default:
    break;
  }
}

void App::printps(const char *url)
{
  char * cacheps = new char[MAXHOSTNAMELEN];
  if (App::startwget(url, cacheps) != 0) {
    starta2ps("a2ps", cacheps);
    //pd App::unlinktmp(cacheps);
  }
  delete[] cacheps;
}

void App::quitps()
{
  if (pspid > 0)
    kill(pspid, SIGKILL);
  //pd App::unlinktmp(cacheps);
}
