/*
 * PDF tool
 *
 * Philippe Dax
 * Jul 1999
 */

#include "global.h"
#include "app.h"

#if DARWIN
#define ACROBAT_PATH	"/Applications/Acrobat Reader 5.0"
#endif

/* global variable */
int pdftool = ACROBAT_TOOL;

static pid_t pdfpid = -1;


static void startacroread(const char *tool, const char *cachepdf)
{
  switch (pdfpid = fork()) {
  case -1:
    error("%s %s", e_fork, tool);
    break;
  case 0:
#if DARWIN
    execlp("open", tool, "-a", ACROBAT_PATH, cachepdf, NULL);
#else
    execlp(tool, tool, cachepdf, NULL);
#endif
    error("%s %s", e_exec, tool);
    exit(1);
  default:
    break;
  }
}

void App::startpdf(const char *url)
{
  trace(DBG_TOOL, "pdftool=%d url=%s", pdftool, url);
  char * cachepdf = new char[MAXHOSTNAMELEN];
  if (App::startwget(url, cachepdf) != 0) { 
    if (pdftool == ACROBAT_TOOL)
      startacroread("acroread", cachepdf);
    else
      error("%s pdf", e_tool);
  }
}

void App::quitpdf()
{
  if (pdfpid > 0) {
    kill(pdfpid, SIGKILL);
    pdfpid = -1;
  }
}
