#include "global.h"
#include "app.h"

#if DARWIN
#define OFFICE_APP	"osascript -e 'tell application \"Microsoft Office\"' -e activate -e 'end tell'"
#endif

/* global variable */
int officetool = OFFICE_TOOL;

static pid_t officepid = -1;


static void startstaroffice(const char *tool, const char *cacheoffice)
{
  switch (officepid = fork()) {
  case -1:
    error("%s %s", e_fork, tool);
    break;
  case 0:
    execlp(tool, tool, cacheoffice, NULL);
#if DARWIN
    execl(OFFICE_APP, tool, cacheoffice, NULL);
#endif
    error("%s %s", tool);
    exit(1);
  default:
    break;
  }
}

void App::startoffice(const char *url)
{
  trace(DBG_FORCE, "officetool=%d url=%s", officetool, url);
  char * cacheoffice = new char[MAXHOSTNAMELEN];
  if (App::startwget(url, cacheoffice) != 0) { 
    if (officetool == OFFICE_TOOL)
      startstaroffice("soffice", cacheoffice);
    else
      error("%s office", e_tool);
  }
}

void App::quitoffice()
{
  if (officepid > 0) {
    kill(officepid, SIGKILL);
    officepid = -1;
  }
}
