/*
 * Modeler tool
 *
 * Philippe Dax
 * Nov 2000
 */

#include "global.h"
#include "app.h"


/* global variable */
int modelertool = VRED_TOOL;

static pid_t modelerpid = -1;


void App::startmodeler()
{
#if defined(WIN32) && !defined(CYGWIN32) // _spawn
  if (modelertool == VRED_TOOL)
    modelerpid = _spawnlp(_P_NOWAIT, "vred", "vred", NULL);
  if (modelertool == VREM_TOOL)
    modelerpid = _spawnlp(_P_NOWAIT, "vrem", "vrem", NULL);
#else // !WIN32

  switch (modelerpid = fork()) {
  case -1:
    error("%s modeler", e_fork);
    break;
  case 0:
    if (modelertool == VRED_TOOL) {
      execlp("vred", "vred", NULL);
      error("%s vred", e_exec);
    }
    if (modelertool == VREM_TOOL) {
      execlp("vrem", "vrem", NULL);
      error("%s vrem", e_exec);
    }
    exit(1);
  default:
    break;
  }
#endif // !WIN32
}

void App::quitmodeler()
{
#ifndef WIN32 // can't kill under windows
  if (modelerpid > 0)
    kill(modelerpid, SIGKILL);
#endif // !WIN32
}
