#ifndef APP_H
#define APP_H

/** masks */
#define AUDIO_MASK	0x0000000f
#define VAT_TOOL	0x00000001
#define RAT_TOOL	0x00000002
#define FPHONE_TOOL	0x00000003

#define VIDEO_MASK	0x000000f0
#define VIC_TOOL	0x00000010

#define WHITEBOARD_MASK	0x00000f00
#define WB_TOOL		0x00000100
#define WBD_TOOL	0x00000200
#define NTE_TOOL	0x00000300
#define MB_TOOL		0x00000400

#define BROWSER_MASK	0x0000f000
#define HTML_MASK	0x00003000
#define NETSCAPE_TOOL	0x00001000
#define MOZILLA_TOOL	0x00002000
#define MMOSAIC_TOOL	0x00003000
#define SLIDECAST_TOOL	0x00004000
#define VRED_TOOL	0x00005000
#define VREM_TOOL	0x00006000
#define VRML_MASK	0x0000c000
#define WEBSPACE_TOOL	0x0000d000
#define VRWEB_TOOL	0x0000e000

#define XTERM_MASK	0x000f0000
#define TELNET_TOOL	0x00010000
#define SSH_TOOL	0x00020000

#define PS_MASK		0x00f00000
#define GV_TOOL		0x00100000
#define GHOSTVIEW_TOOL	0x00200000
#define ACROBAT_TOOL	0x00300000
#define OFFICE_TOOL	0x00400000
#define A2PS_TOOL	0x00500000

#define MP3_MASK	0x0f000000
#define MPG123_TOOL	0x01000000
#define XAUDIO_TOOL	0x02000000
#define TIMIDITY_TOOL	0x03000000
#define FREEAMP_TOOL	0x04000000
#define MTVP_TOOL	0x0d000000
#define MPEGPLAY_TOOL	0x0e000000

/** ports */
#define AUDIO_INCR_PORT		2 // rtp
#define VIDEO_INCR_PORT		4 // rtp
#define WHITEBOARD_INCR_PORT	6 // udp
#define SLIDECAST_INCR_PORT	7 // udp

/** sounds */
#define GATESND		whistle
#define DOORCLOSESND	doorclose
#define DOOROPENSND	doorbell
#define DRIPSND		drip
#define SHOOTSND	shoot
#define OUILLESND	ouille
#define BUBBLESSND	bubbles

extern int audiotool;
extern int audioactive;
extern int videotool;
extern int whiteboardtool;
extern int browsertool;
extern int vrmltool;
extern int slidecasttool;
extern int modelertool;
extern int pstool;
extern int pdftool;
extern int officetool;
extern int mp3tool;
extern int miditool;
extern int mpgtool;

extern const char *whistle;
extern const char *doorbell;
extern const char *doorclose;
extern const char *drip;
extern const char *shoot;
extern const char *ouille;
extern const char *bubbles;

/**
 * App class
 */
class App {
 public:

  static void quitTools();
  static void quitAllTools();

  static int startwget(const char *url, char *cachepath, char options[] = "-qO");
  static int checkUrl(const char *url);
  static void unlinktmp(const char *path);

  static void startaudio(const char *chanstr);
  static void playSound(const char *snd);
  static void quitaudio();

  static void startvideo(const char *mc);
  static void quitvideo();

  static void startwhiteboard(const char *mc);
  static void quitwhiteboard();

  static void startxterm(const char *host);
  static void quitxterm();

  static void startbrowser(const char *url, bool rewrite = true);
  static void quitbrowser();
  static void startvrml(const char *url);
  static void quitvrml();

  static void startslidecast(const char *mc);
  static void quitslidecast();

  static void startmodeler();
  static void quitmodeler();

  static void viewps(const char *url);
  static void printps(const char *url);
  static void quitps();
  static void startpdf(const char *url);
  static void quitpdf();
  static void startoffice(const char *url);
  static void quitoffice();

  static void startmp3(const char *url);
  static void stopmp3();
  static void pausemp3();
  static void contmp3();

  static void startmidi(const char *url);
  static void stopmidi();
  static void pausemidi();
  static void contmidi();

  static void startmpg(const char *url);
  static void stopmpg();
  static void pausempg();
  static void contmpg();

};

#endif // APP_H

