/*********************************************************************
 *
 * Authors: Vincenzo Ciaschini - Vincenzo.Ciaschini@cnaf.infn.it 
 *
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright holders.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Parts of this code may be based upon or even include verbatim pieces,
 * originally written by other people, in which case the original header
 * follows.
 *
 *********************************************************************/
/***************************************************************************
 *  filename  : GSISocketClient.h
 *  authors   : Salvatore Monforte <salvatore.monforte@ct.infn.it>
 *  copyright : (C) 2001 by INFN
 ***************************************************************************/

// $Id:

/**
 * @file GSISocketServer.h
 * @brief The header file for ssh based Socket Server Object.
 * This file contains definitions for secure Socket Server used in
 * order to communicate with the Resource Broker.\ It uses SSH standard.
 * @author Salvatore Monforte salvatore.monforte@ct.infn.it
 * @author comments by Marco Pappalardo marco.pappalardo@ct.infn.it and Salvatore Monforte
 */

#ifndef VOMS_GSISOCKETCLIENT
#define VOMS_GSISOCKETCLIENT



/** This super class header file. */
#include <openssl/evp.h>
#include <openssl/x509.h>
#include <openssl/ssl.h>

#include <string>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

extern "C" {
#include "sslutils.h"
}

/** 
 * The secure Client.
 * This object acts as Client in the message exchange. It asks the client for
 * connections referencing an agent for secure message exchange.
 * @author Salvatore Monforte salvatore.monforte@ct.infn.it
 * @author comments by Marco Pappalardo marco.pappalardo@ct.infn.it and Salvatore Monforte
 */
class GSISocketClient
{

public:
  /**
   * Constructor.
   * @param p the secure server port.
   * @param b the backlog, that is the maximum number of outstanding connection requests.
   */
  GSISocketClient(const std::string&, int, int, void* = NULL);
  /**
   * Destructor.
   */  
  virtual ~GSISocketClient();

  void RedirectGSIOutput(FILE *fp) { gsi_logfile = fp; }
  /**
   * Set the server contact. 
   * @param contact the server contact string to set.
   */
  void ServerContact(const std::string& contact) { _server_contact = contact; }
  /**
   * Sets required connection flags.
   * @param flags is a bitwise or of all the flags required.
   */
  //  void SetFlags(int flags);


  //  void SetLogger(void *l);

  /**
   * Open the connection.
   * @return true for successful opening, false otherwise.
   */
  virtual bool Open();
  /**
   * Close the connection.
   * @return true for successful close, false otehrwise.
   */
  virtual void Close();

  virtual bool post_connection_check(SSL*);
  virtual bool LoadCredentials(const char *, X509 *, STACK_OF(X509) *, EVP_PKEY *);

protected:
  /**
   * Initialize GSI Authentication.
   * This method asks the server for authentication.
   * @param sock the socket descriptot
   * @return true on success, false otherwise.
   */
  bool InitGSIAuthentication(int sock);

private:
  std::string host;
  int port;
  int version;
   /** The Secure Shell context identifier. */
  gss_ctx_id_t context; 
  gss_cred_id_t credential;
  std::string _server_contact;
   //bool _do_mutual_authentication;
  //  int conflags;
  FILE *gsi_logfile;
  bool opened;
  int sck;

public:
  std::string     own_subject;
  std::string     own_ca;
  EVP_PKEY       *upkey;
  X509           *ucert;
  STACK_OF(X509) *cert_chain;
  char           *cacertdir;
  std::string     peer_subject;
  std::string     peer_ca;
  EVP_PKEY       *peer_key;
  X509           *peer_cert;
  //  void           *logh;
  SSL *ssl;
  SSL_CTX *ctx;
  BIO *conn;
  void *pvd;

  bool Send(const std::string &s);
  bool Receive(std::string &s);

private:
  struct sockaddr_in peeraddr_in;	/**< Address for peer socket.*/
  std::string error;
  void SetError(const std::string&);
  void SetErrorGlobus(const std::string&, int, int, int);
  void SetErrorOpenSSL(const std::string& );

public:
  std::string GetError();
  void SetTimeout(int t);

private:
  int timeout;
};

#endif

/*
  Local Variables:
  mode: c++
  End:
*/





