#
#    Uncomplicated VM Builder
#    Copyright (C) 2007-2009 Canonical Ltd.
#    
#    See AUTHORS for list of contributors
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License version 3, as
#    published by the Free Software Foundation.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    Logging

import logging
import os
import tempfile

format = '%(asctime)s %(levelname)-8s: %(message)s'

fd, logfile = tempfile.mkstemp()

# Log everything to the logfile
logging.basicConfig(format=format, level=logging.DEBUG, datefmt='%Y-%m-%d %H:%M', stream=os.fdopen(fd, 'a+'), filemode='w')

console = logging.StreamHandler()
console.setLevel(logging.INFO)
console.setFormatter(logging.Formatter(format))
logging.getLogger('').addHandler(console)

def set_verbosity(option, opt_str, value, parser):
    if opt_str == '--debug':
        console.setLevel(logging.DEBUG)
    elif opt_str == '--verbose':
        console.setLevel(logging.INFO)
    elif opt_str == '--quiet':
        console.setLevel(logging.CRITICAL)
