/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file Stats_window.hpp
 */

#ifndef STATS_WINDOW_HPP
#define STATS_WINDOW_HPP

class Container;
//#include "trace/Container.hpp"
class Trace;
class Render_stats_opengl;
class Stats_window;


//#include <QGLWidget>
#include "ui_stats_viewer.h"




/*!
 * \enum stattype_t
 * \brief Enumeration for the kind of chart to print stats.
 *
 */
typedef enum {
  _HDIAGRAM_INDEX,
  _DIAGRAM_INDEX,
  _COUNTER_INDEX
} stattype_t;
  

/*!
 * \class Stats_window
 * \brief Class used to display statistics of containers.
 *
 */

class Stats_window : public QMainWindow, protected Ui::stats_viewer {
    
    Q_OBJECT
    
  private:

    std::string _file_viewed;
    Trace *_trace;
    double _start_time;
    double _end_time;

    /*!
     * \brief Layout which will contain the stats area.
     */
    QVBoxLayout* _ui_stats_area_layout;
    Render_stats_opengl* _ui_stats_area;

    std::vector<Container *> _selected_containers;
    int _number_of_selected_container;
    int _screen_width, _screen_height;

    // For the scroll bars
    int _x_translated, _y_translated;

public:
    /*!
     * Default constructor
     * \param parent The parent widget of the window.
     */
    Stats_window(QWidget *parent);

    ~Stats_window();
    
    /*!
     * \fn set_container_names()
     * \brief Set the names of the containers in the tree
    */
    void set_container_names();

    /*!
     * \fn set_filename(std::string filename)
     * \brief Set the name of the file trace.
     * \param filename The file name.
    */
    void set_filename(std::string filename);

    /*!
     * \fn set_trace(Trace *trace)
     * \brief Set the trace parsed (give the container names)
     * \param trace The trace.
    */
    void set_trace(Trace *trace);

    /*!
     * \fn init_window()
     * \brief Initialise the statistic window : set the container names,
     the times and clear what could have been here before
    */
    void init_window();

    /*!
     * \fn Reinit_scroll_bars()
     * \brief Reinitialize the scroll bar to their default values (0)
     */
    void Reinit_scroll_bars();

    /*!
      \fn close_window()
      \brief Properly close the window
     */
    void close_window();


private:
    void set_container_names_rec(QTreeWidgetItem *current_node, Container *current_container);

    /*!
     * \brief Fill the vector of selected containers depending on the ones chosen in the tree widget 
     */
    void set_selected_nodes(std::string);


    /*!
     * \brief This functions receives all keyboard events.
     * \param event The event triggered by the keyboard event.
     */
    void keyPressEvent(QKeyEvent *event);


private slots:
    void on_reload_button_clicked();
    void on_export_button_clicked();

    void on_y_scroll_valueChanged(int new_value);
    void on_x_scroll_valueChanged(int new_value);
};

#endif // STATS_WINDOW_HPP
