/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/

#include <fstream>
#include <string>
#include <map>
/* -- */
#include <otf.h>
/* -- */
#include <QObject>
/* -- */
#include "trace/values/Values.hpp"
#include "trace/Trace.hpp"
/* -- */
#include "parser/Parser.hpp"
#include "parser/ParserOTF.hpp"
#include "parser/ParserDefinitionOTF.hpp"
#include "parser/ParserEventOTF.hpp"
/* -- */

using namespace std;

ParserOTF::ParserOTF() {
    _is_finished = false;
    _is_canceled = false;
}

void ParserOTF::parse(const string &filename, Trace &trace, bool finish_trace_after_parse) {

    set_file_to_parse(filename);

    ParserDefinitionOTF *parserdefinition = new ParserDefinitionOTF();
    ParserEventOTF *parserevent = new ParserEventOTF();

    OTF_FileManager* manager = OTF_FileManager_open(100);
    int ret = 0;

    if(manager == NULL) {
        cerr << QObject::tr("manager failed\n").toStdString() << endl;
        delete parserdefinition;
        delete parserevent;
        return;
    }

    OTF_Reader* _reader = OTF_Reader_open(filename.c_str(), manager);
    if(_reader == NULL) {
        cerr << QObject::tr("open failed\n").toStdString() << endl;
        delete parserdefinition;
        delete parserevent;
        OTF_FileManager_close(manager);
        return;
    }

    parserdefinition->set_handlers(&trace);
    parserdefinition->read_definitions(_reader);
    parserdefinition->create_container_types(&trace);

    //parserdefinition->print_definitions();

    parserevent->set_number_event_read_by_each_pass(_reader, 10000);
    parserevent->set_handlers(&trace);

    while ((ret = parserevent->read_events(_reader)) != 0 && !_is_canceled) {
        if(ret == -1) {
            cerr << QObject::tr("Error while reading events. Aborting").toStdString() << endl;
            break;
        }
    }

    finish();

    if(finish_trace_after_parse) { // true by default
        trace.finish();
    }

    delete parserevent;
    delete parserdefinition;

    OTF_Reader_close(_reader);
    OTF_FileManager_close(manager);
}


void ParserOTF::set_file_to_parse(const string &filename) {
    _file_to_parse = filename;
}


float ParserOTF::get_size_loaded() const {
    return ParserEventOTF::get_size_loaded();
}

bool ParserOTF::is_end_of_parsing() const{
    return _is_finished;
}

void ParserOTF::finish() {
    _is_finished = true;
}

void ParserOTF::set_canceled() {
    _is_canceled = true;
}
