create procedure load_graphs (in dir varchar := 'dumps/')
{
  declare arr any;
  declare g varchar;

  arr := sys_dirlist (dir, 1);
  log_enable (2, 1);
  foreach (varchar f in arr) do
    {
      if (f like '*.ttl')
	{
	  declare continue handler for sqlstate '*'
	    {
	      log_message (sprintf ('Error in %s', f));
	    };
  	  g := file_to_string (dir || '/' || f || '.graph');
	  DB.DBA.TTLP_MT (file_open (dir || '/' || f), g, g, 255);
	}
    }
  exec ('checkpoint');
}
;
