
// created 11.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL


#include "ViewPDFDocument.h"

#include "AppController.h"

#include <Foundation/NSString.h>
#include <Foundation/NSException.h>


/*
 * Non-Public methods.
 */
@interface ViewPDFDocument(Private)
@end


/*
 * An NSDocument that loads a PDF file and holds a
 * corrensponding PDFDocument object. This object
 * can be used by the application to access the
 * content and properties of the file. The PDFDocument
 * is retained and released by this class.
 */
@implementation ViewPDFDocument

/*
 * Designated initializer.
 */
- (id) init
{
   if (self = [super init])
   {
      pdfDocument = nil;
   }

   return self;
}


- (void) dealloc
{
   [pdfDocument release];
   [super dealloc];
}


/*
 * Dump the outline recursive. Only for debugging.
 */
static void printOutlineItems(NSArray* items, int level)
{
   int i;
   NSEnumerator* e = [items objectEnumerator];
   PDFOutlineItem* anItem;
   
   NSMutableString* pattern = [[NSMutableString alloc] init];
   for (i = 0; i < level; i++)
   {
      [pattern appendString: @"   "];
   }
   [pattern appendString: @"%@"];

   while ((anItem = [e nextObject]))
   {
      NSLog(pattern, [anItem title]);
      if ([anItem hasKids])
      {
         int n = level + 1;
         printOutlineItems([anItem kids], n);
      }
   }

   [pattern release];
}


/*
 * Read a PDF document from a file and create a corresponding
 * PDFDocument object. 
 */
- (BOOL) readFromFile: (NSString*)fileName ofType: (NSString*)docType
{
   pdfDocument = [[PDFDocument documentFromFile: fileName] retain];

   // Dump outline (only for testing purpose)
   /*
   if (succeeded)
   {
      if ([pdfDoc hasOutline])
      {
         NSLog(@"**** Document Outline:");
         printOutlineItems([[pdfDoc outline] items], 1);
      }
      else
      {
         NSLog(@"Document has not Outline");
      }
   }
   */

   return [pdfDocument isOk];
}


/*
 * Returns the PDFDocument hold by this instance.
 */
- (PDFDocument*)pdfDocument
{
   return pdfDocument;
}


/*
 * Only for debugging.
 */
- (void) close
{
   NSLog(@"Close Document");
   [super close];
}


/*
 * Create an instance of DocumentWindowController that will
 * control a window that displays this document.
 */ 
- (void) makeWindowControllers
{
   [[AppController sharedController] createAndDisplayWindowForDocument: self];

   NSLog(@"new window controller created");   
}


@end
