
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#ifndef _H_TRANSFORMABLE_IMAGE_VIEW
#define _H_TRANSFORMABLE_IMAGE_VIEW

#include <Foundation/NSString.h>
#include <Foundation/NSGeometry.h>
#include <AppKit/NSEvent.h>
#include <AppKit/NSImageView.h>


// Notifications sent by the ImageView
extern NSString* N_SelectionChanged;
extern NSString* N_SelectionRemoved;
extern NSString* N_ScrollingRequested;

// Keys for the user information dictionary
// may be associated with notifications
extern NSString* UserInfoKeySelection;
extern NSString* UserInfoKeyScrollAmount;


@interface ExtendedImageView : NSImageView
{
   NSRect  selection;
   NSPoint selectionStart;
   BOOL    drawSelection;
}

- (id) initWithFrame: (NSRect)frame;
- (void) dealloc;

- (void) setSelection: (NSRect)aSelection;
- (void) removeSelection;

- (void) drawRect: (NSRect)aRect;

- (void) mouseDown: (NSEvent*)event;
- (void) mouseDragged: (NSEvent*)event;
- (void) mouseUp: (NSEvent*)event;

@end

#endif
