
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#include "AppController.h"
#include "DocumentWindow.h"
#include "DocumentWindowController.h"
#include "ViewPDFDocument.h"
#include "PrefsController.h"
#include "ViewPDF.h"

#include <Foundation/NSString.h>
#include <Foundation/NSException.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSEnumerator.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSBundle.h>
#include <Foundation/NSUserDefaults.h>
#include <Foundation/NSValue.h>
#include <AppKit/NSApplication.h>
#include <AppKit/NSDocumentController.h>
#include <AppKit/NSMenu.h>
#include <AppKit/NSNibLoading.h>
#include <AppKit/NSFontManager.h>


#define PAPERSIZES_KEY  @"Papersizes"


/* shared instance of AppController */
AppController*  sharedInstance;

/*
 * Non-Public methods.
 */
@interface AppController(Private)
- (void) initPaperSizes;
+ (void) initDefaults;
@end

/*
 * The Main Controller of the ViewPDF Application.
 */
@implementation AppController

-(id) init
{
   if (self = [super init])
   {
      papersizesPlist = nil;
      prefsController = nil;
   }

   return self;
}


-(void) dealloc
{
   NSLog(@"dealloc AppController, retain count is %d", [self retainCount]);

   [papersizesPlist release];
   [prefsController release];

   [super dealloc];
}


/*
 * Class initialization.
 */
+ (void) initialize
{
   [super initialize];
   
   sharedInstance = nil;

   [self initDefaults];
}


/*
 * Return a shared instance of the Applications controller.
 * Note that if this instance has been obtained once, someone
 * has to release this instance.
 */
+ (AppController*) sharedController
{
   if (sharedInstance == nil)
   {
      NSLog(@"create shared instance of AppController");
      sharedInstance = [[AppController alloc] init];
   }

   return sharedInstance;
}


- (void) applicationWillFinishLaunching: (NSNotification *) aNotification 
{
}


- (void) applicationDidFinishLaunching: (NSNotification *) aNotification 
{
   NSDocumentController* documentController;
   NSArray*              fonts;
   NSString*             aFont;
   NSEnumerator*         e;

   [self initPaperSizes];

   //documentController = [NSDocumentController sharedDocumentController];
   //[documentController openDocument: self];
   /*
   fonts = [[NSFontManager sharedFontManager] availableFonts];
   e = [fonts objectEnumerator];
   NSLog(@"----- available fonts (%d)-----", [fonts count]);
   while((aFont = [e nextObject]))
   {
      NSLog(aFont);
   }
   NSLog(@"---------------------------");
   */
}


/*
 * Create and display a new Image Window together with a controller.
 * The created controller is returned. Both, window and controller
 * are autoreleased. The controller is added the list of window
 * controllers for the specified document.
 */
- (DocumentWindowController*) 
createAndDisplayWindowForDocument: (ViewPDFDocument*)aDocument
{
   DocumentWindow*           win;
   DocumentWindowController* theController;

   win = [[DocumentWindow alloc] init];
   // win will be released by it's controller
   [[win documentView] displayMessage: @"Loading Document ..."];

   theController = [[[DocumentWindowController alloc] initWithWindow: win] autorelease];
   [aDocument addWindowController: theController];
   [win setDelegate: theController];

   // We have to do this ourself, as there is currently no nib file
   [aDocument windowControllerDidLoadNib: theController];

   // FIXME if possible, don't know whether this is a bug or not.
   // It seems that the isReleasedWhenClosed flag is set to NO
   // when the controller has no document on init. The flag is
   // not toggled when a document is associated to the controller.
   [win setReleasedWhenClosed: YES];
   
   /*
   NSLog(@"CHECKPOINT controllers document %@", [[theController document] displayName]);
   NSLog(@"CHECKPOINT isReleasedWhenClosed %d", [win isReleasedWhenClosed]);
   */
   
   [win center];
   [win orderFrontRegardless];
   [win makeKeyWindow];
   [win display];

   //[win makeKeyAndOrderFront: self];

   return theController;
}


/*
 * Initiate the papersizes menu the Papersizes.plist
 * property file.
 */
- (void) initPaperSizes
{
   NSString*      plistPath;
   NSMenu*        psMenu;
   NSEnumerator*  e;
   NSString*      aPapersize;
   NSDictionary*  papersizes;
   NSArray*       sortetPapersizes;

   plistPath =
      [[NSBundle mainBundle] pathForResource: @"Papersizes" ofType: @"plist"];
   NSAssert(plistPath != nil, @"available Papersizes not found");

   papersizesPlist = [[NSDictionary dictionaryWithContentsOfFile: plistPath] retain];
   papersizes      = [papersizesPlist objectForKey: PAPERSIZES_KEY];

   NSAssert(papersizes != nil, @"could not load papersizes from plist");

   sortetPapersizes = [[papersizes allKeys] 
                         sortedArrayUsingSelector: @selector(caseInsensitiveCompare:)];

   /*
   psMenu = [[[NSApp mainMenu] itemWithTitle: @"Papersize"] submenu];

   e = [sortetPapersizes objectEnumerator];
   while (aPapersize = [e nextObject])
   {
      [psMenu addItemWithTitle: aPapersize 
              action: @selector(setPaperSize:)
              keyEquivalent: @""];
   }
   */
}


/*
 * Returns the available papersizes.
 */
- (NSDictionary*) papersizes
{
   return [papersizesPlist objectForKey: PAPERSIZES_KEY];
}


/*
 * Register the standard User-Defaults.
 */
+ (void) initDefaults
{
   NSMutableDictionary* stdDefs = [NSMutableDictionary dictionary];
   NSUserDefaults*      defaults = [NSUserDefaults standardUserDefaults];

   defaults = [NSUserDefaults standardUserDefaults];
   stdDefs = [NSMutableDictionary dictionary];
   
   [stdDefs setObject: @"YES" forKey: PREFS_TOOLBAR_VISIBLE];

   [defaults registerDefaults: stdDefs];
}


/*
 * Display the applications preferences dialog.
 */
- (void) showPrefs: (id)sender
{
   if (!prefsController)
   {
      [NSBundle loadNibNamed: @"preferences.gorm" owner: self];
   }

   [[prefsController window] orderFrontRegardless];
   [[prefsController window] makeKeyWindow];
   [[prefsController window] display];
}


/*
 * Callback for PrefsController to set it's instance
 * when loaded from nib.
 */
- (void) setPrefsController: (id)controller
{
   prefsController = [controller retain];
}


/*
 * Display an info dialog for the ViewPDF application.
 */
- (void)showInfoPanel:(id)sender
{
  [[NSApplication sharedApplication] orderFrontStandardInfoPanel:sender];
}



@end
