#!/usr/bin/env python
# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

from distutils.core import setup

setup(name = "videoporama",
      version = "0.8.0",
      description = "Videoporama - Application to make video of image slideshow",
      author = "Ponchaut Olivier - Levray Dominique",
      author_email = "videoporama@numericable.be",
      url = "http://www.videoporama.tuxfamily.org",
      data_files = [("./",["README",
                                      "INSTALL",
                                      "licences.txt",
                                      "about.py",
                                      "configuration.py",
                                      "DefText.py",
                                      "DefTextDlg.py",
                                      "DefZoomPoint.py",
                                      "DefZoomPointDlg.py",
                                      "DocHelpDlg.py",
                                      "Documentation.py",
                                      "GlobalDefines.py",
                                      "main_win.py",
                                      "lot.py",
                                      "lotDlg.py",
                                      "start.py",
                                      "interface.py",
                                      "videoporama.py",
                                      "mplayer.py",
                                      "process.py",
                                      "showprogress.py",
                                      "statusconf.py",
                                      "VideoporamaOFD.xml",
                                      "warning.py"]),
                    ("locale",[       "locale/videoporama_fr.qm",
                                      "locale/videoporama_es.qm",
                                      "locale/videoporama_it.qm" ]),
                    ("help",[         "help/en-configbox.html",
                                      "help/en-file.html",
                                      "help/en-main.html",
                                      "help/en-lotbox.html",
                                      "help/en-render.html",
                                      "help/en-tabmontage.html",
                                      "help/en-tabplan.html",
                                      "help/en-tabsequence.html",
                                      "help/en-textbox.html",
                                      "help/en-timeline.html",
                                      "help/en-zoombox.html",
                                      "help/fr-main.html",
                                      "help/fr-configbox.html",
                                      "help/fr-file.html",
                                      "help/fr-lotbox.html",
                                      "help/fr-render.html",
                                      "help/fr-tabmontage.html",
                                      "help/fr-tabplan.html",
                                      "help/fr-tabsequence.html",
                                      "help/fr-textbox.html",
                                      "help/fr-timeline.html",
                                      "help/fr-zoombox.html"]),
                    ("help/images",[  "help/images/Animation.png",
                                      "help/images/en-confdlg1.png",
                                      "help/images/en-confdlg2.png",
                                      "help/images/en-confdlg3.png",
                                      "help/images/en-confdlg4.png",
                                      "help/images/en-confdlg5.png",
                                      "help/images/en-interface.png",
                                      "help/images/en-lot.png",
                                      "help/images/en-render.png",
                                      "help/images/en-tabimage.png",
                                      "help/images/en-tabmontage.png",
                                      "help/images/en-tabzoom.png",
                                      "help/images/en-textdlg1.png",
                                      "help/images/en-textdlg2.png",
                                      "help/images/en-textdlg3.png",
                                      "help/images/en-transition.png",
                                      "help/images/en-zoomdlg.png",
                                      "help/images/en.png",
                                      "help/images/fixe.png",
                                      "help/images/fr-confdlg1.png",
                                      "help/images/fr-confdlg2.png",
                                      "help/images/fr-confdlg3.png",
                                      "help/images/fr-confdlg4.png",
                                      "help/images/fr-confdlg5.png",
                                      "help/images/fr-interface.png",
                                      "help/images/fr-lotdlg.png",
                                      "help/images/fr-render.png",
                                      "help/images/fr-tabimage.png",
                                      "help/images/fr-tabmontage.png",
                                      "help/images/fr-tabzoom.png",
                                      "help/images/fr-textdlg1.png",
                                      "help/images/fr-textdlg2.png",
                                      "help/images/fr-textdlg3.png",
                                      "help/images/fr-transition.png",
                                      "help/images/fr-zoomdlg.png",
                                      "help/images/fr.png",
                                      "help/images/mobile.png",
                                      "help/images/preview.png",
                                      "help/images/timeline.png",
                                      "help/images/ToolBox.png"]),
                    ("icons", ["icons/open.png",
                                      "icons/add.png",
                                      "icons/add_picture.png",
                                      "icons/add_text.png",
                                      "icons/arrow_left.png",
                                      "icons/arrow_right.png",
                                      "icons/bin.png",
                                      "icons/color.png",
                                      "icons/config.png",
                                      "icons/copy.png",
                                      "icons/cut.png",
                                      "icons/delete.png",
                                      "icons/exit.png",
                                      "icons/film.png",
                                      "icons/Frame_Buble.png",
                                      "icons/Frame_Ellipse.png",
                                      "icons/Frame_Rectangle.png",
                                      "icons/Frame_RoundRec.png",
                                      "icons/Frame_TextOnly.png",
                                      "icons/Help.png",
                                      "icons/new.png",
                                      "icons/nok.png",
                                      "icons/ok.png",
                                      "icons/paste.png",
                                      "icons/pencil.png",
                                      "icons/pencil_add.png",
                                      "icons/pencil_delete.png",
                                      "icons/pictures.png",
                                      "icons/player_pause.png",
                                      "icons/player_play.png",
                                      "icons/player_stop.png",
                                      "icons/preview.png",
                                      "icons/redo.png",
                                      "icons/rotationd.png",
                                      "icons/rotationg.png",
                                      "icons/save.png",
                                      "icons/save_as.png",
                                      "icons/tavbottom.png",
                                      "icons/text_align_center.png",
                                      "icons/text_align_justif.png",
                                      "icons/text_align_left.png",
                                      "icons/text_align_right.png",
                                      "icons/text_align_vbottom.png",
                                      "icons/text_align_vcenter.png",
                                      "icons/text_align_vup.png",
                                      "icons/text_bold.png",
                                      "icons/text_italic.png",
                                      "icons/text_normal.png",
                                      "icons/text_outerline.png",
                                      "icons/text_shadow_bottom_left.png",
                                      "icons/text_shadow_bottom_right.png",
                                      "icons/text_shadow_up_left.png",
                                      "icons/text_shadow_up_right.png",
                                      "icons/text_underline.png",
                                      "icons/textfield_delete.png",
                                      "icons/undo.png",
                                      "icons/vcard_add.png",
                                      "icons/vcard_delete.png",
                                      "icons/vcard_edit.png",
                                      "icons/videoporama.png",
                                      "icons/zoom.jpg",
                                      "icons/videoporama_big.png"]),
                       ("iconstr",[   "iconstr/bar_bottom.png",
                                      "iconstr/bar_left.png",
                                      "iconstr/barn_bottomleft.png",
                                      "iconstr/barn_horz.png",
                                      "iconstr/barn_topleft.png",
                                      "iconstr/barn_vert.png",
                                      "iconstr/bar_right.png",
                                      "iconstr/bar_top.png",
                                      "iconstr/box_bottomcentre.png",
                                      "iconstr/box_bottomleft.png",
                                      "iconstr/box_bottomright.png",
                                      "iconstr/box_leftcentre.png",
                                      "iconstr/box_rightcentre.png",
                                      "iconstr/box_topcentre.png",
                                      "iconstr/box_topleft.png",
                                      "iconstr/box_topright.png",
                                      "iconstr/burst.png",
                                      "iconstr/checkerboard_small.png",
                                      "iconstr/clock_clockwise12.png",
                                      "iconstr/clock_clockwise6.png",
                                      "iconstr/diag_bottomleft.png",
                                      "iconstr/diag_bottomright.png",
                                      "iconstr/diag_topleft.png",
                                      "iconstr/diag_topright.png",
                                      "iconstr/fourbox_in.png",
                                      "iconstr/fourbox_out.png",
                                      "iconstr/horizontal_barn_doors.png",
                                      "iconstr/horizontal_blinds.png",
                                      "iconstr/iris_circle.png",
                                      "iconstr/iris_rectangle.png",
                                      "iconstr/matrix_snake_toplefthorizontal.png",
                                      "iconstr/symmetric_clock.png",
                                      "iconstr/tr-00-00.png",
                                      "iconstr/tr-01-00.png",
                                      "iconstr/tr-02-00.png",
                                      "iconstr/tr-02-01.png",
                                      "iconstr/tr-02-02.png",
                                      "iconstr/tr-02-03.png",
                                      "iconstr/tr-02-04.png",
                                      "iconstr/tr-02-05.png",
                                      "iconstr/tr-02-06.png",
                                      "iconstr/tr-02-07.png",
                                      "iconstr/tr-02-08.png",
                                      "iconstr/tr-03-00.png",
                                      "iconstr/tr-03-01.png",
                                      "iconstr/tr-03-02.png",
                                      "iconstr/tr-03-03.png",
                                      "iconstr/tr-03-04.png",
                                      "iconstr/tr-03-05.png",
                                      "iconstr/tr-03-06.png",
                                      "iconstr/tr-03-07.png",
                                      "iconstr/tr-03-08.png",
                                      "iconstr/tr-04-00.png",
                                      "iconstr/tr-04-01.png",
                                      "iconstr/tr-04-02.png",
                                      "iconstr/tr-04-03.png",
                                      "iconstr/tr-04-04.png",
                                      "iconstr/tr-04-05.png",
                                      "iconstr/tr-04-06.png",
                                      "iconstr/tr-04-07.png",
                                      "iconstr/tr-05-00.png",
                                      "iconstr/tr-05-01.png",
                                      "iconstr/tr-05-02.png",
                                      "iconstr/tr-05-03.png",
                                      "iconstr/tr-06-00.png",
                                      "iconstr/tr-06-01.png",
                                      "iconstr/tr-06-02.png",
                                      "iconstr/tr-06-03.png",
                                      "iconstr/tr-08-00.png"]),
                       ("luma",[      "luma/bar_bottom.png",
                                      "luma/bar_left.png",
                                      "luma/barn_bottomleft.png",
                                      "luma/barn_horz.png",
                                      "luma/barn_topleft.png",
                                      "luma/barn_vert.png",
                                      "luma/bar_right.png",
                                      "luma/bar_top.png",
                                      "luma/box_bottomcentre.png",
                                      "luma/box_bottomleft.png",
                                      "luma/box_bottomright.png",
                                      "luma/box_leftcentre.png",
                                      "luma/box_rightcentre.png",
                                      "luma/box_topcentre.png",
                                      "luma/box_topleft.png",
                                      "luma/box_topright.png",
                                      "luma/burst.png",
                                      "luma/checkerboard_small.png",
                                      "luma/clock_clockwise12.png",
                                      "luma/clock_clockwise6.png",
                                      "luma/diag_bottomleft.png",
                                      "luma/diag_bottomright.png",
                                      "luma/diag_topleft.png",
                                      "luma/diag_topright.png",
                                      "luma/fourbox_in.png",
                                      "luma/fourbox_out.png",
                                      "luma/horizontal_barn_doors.png",
                                      "luma/horizontal_blinds.png",
                                      "luma/iris_circle.png",
                                      "luma/iris_rectangle.png",
                                      "luma/matrix_snake_toplefthorizontal.png",
                                      "luma/symmetric_clock.png"])],
      scripts = ["videoporama"],
      long_description = """
Videoporama is an application to make diaporama from images export in video file. It is written in Python using QT4 and the PyQt4 GUI toolkit. It use MJPEGtools, ffmpeg, sox and PIL to build images and convert them to movie
"""          
      )
