#!/usr/bin/env python
# -*- coding: UTF8 -*-

###
# This file is part of VideoManager.
#
# xml2translate is the legal property of Erwan Briand <xbright2005@gmail.com>
# Copyright (c) 2006 Erwan Briand
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import pprint,xml.dom.minidom
from xml.dom.minidom import Node

class xml2translate:

    def __init__(self,filetoparse):
	self.doc = xml.dom.minidom.parse(filetoparse)

    def GetTranslationValueByEntry(self,entry):
	mapping = {}

	for node in self.doc.getElementsByTagName("translate_entry"):
		isbn = node.getAttribute("name")
		if isbn == entry:
			title = ""
			for node3 in node.childNodes:
				if node3.nodeType == Node.TEXT_NODE:
					title += node3.data
			title = title.replace("[n]","\n",50)
			title = title.replace("[b]","<b>",50)
			title = title.replace("[/b]","</b>",50)
			title = title.replace("[i]","<i>",50)
			title = title.replace("[/i]","</i>",50)
			return title
