#!/usr/bin/env python
# -*- coding: UTF8 -*-

###
#
# VideoManager is the legal property of Erwan Briand <xbright2005@gmail.com>
# Copyright (c) 2006 Erwan Briand
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

# VideoManager utilise un module de gestion d'erreurs écrit en Python
# Ce module est sous GPL et vous pouvez vous aussi l'utiliser !
# Plus d'informations : http://www.codingteam.net/programmationvoir-25.html

###
#
# Traduction

### Classes VideoManager
from VideoManagerCommon import Mediatheque
from VideoManagerCommon import Options
from VideoManagerCommon import FonctionsDeBases

Mediatheque = Mediatheque()
Options = Options()
FonctionsDeBases = FonctionsDeBases()

try:
	LOCALE = Options.ObtenirLaConfiguration(6)
except:
	LOCALE = "fr"
###
#
# Début de la gestion des erreurs

try:
	import sys,os
	from xml2translate import xml2translate

	translation = xml2translate(os.path.dirname(os.path.realpath(__file__))+"/lang/translate-"+LOCALE+".xml")
except:
	print "Loading translation file...\t\t\t[failed]\nModules needed: sys, os, xml2translate"
	sys.exit()

try:
	from ErrorManager import Manage
	GestionErreur = Manage()
	GestionErreur.SetNomFichier("VideoManager")
	if LOCALE == "fr":
		GestionErreur.SetLocale("fr")
	else:
		GestionErreur.SetLocale("other")
except:
	print translation.GetTranslationValueByEntry("txt1")
	sys.exit()

try:
	import traceback
except:
	print translation.GetTranslationValueByEntry("txt1")
	sys.exit()

def Myexcepthook(type, value, tb):
	total = ""
        lines=traceback.format_exception(type, value, tb)
	for i in range(len(lines)):
		total = total + lines[i]
	GestionErreur.Alerte(2,translation.GetTranslationValueByEntry("txt2")+"\n\n---------------------Traceback lines-----------------------\n"+total+"\n---------------------------------------------------------------",0)
        sys.exit()

sys.excepthook=Myexcepthook

# Fin de la gestion des erreurs
#
###


try:
	import gtk
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","gtk",1),0)
	sys.exit()

try:
	import ConfigParser
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","ConfigParser",1),0)
	sys.exit()

try:
	import commands
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","commands",1),0)
	sys.exit()

try:
	import sqlite
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","sqlite",1),0)
	sys.exit()

try:
	import glob
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","glob",1),0)
	sys.exit()

try:
 	import re
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","re",1),0)
	sys.exit()

try:
	import webbrowser
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","webbrowser",1),0)
	sys.exit()

### Classes de Tepache : GLADE (interface utilisateur)
from SimpleGladeApp import SimpleGladeApp
from SimpleGladeApp import bindtextdomain

app_name = "VideoManager"
app_version = "0.5"
glade_dir = ""
locale_dir = ""
bindtextdomain(app_name, locale_dir)

### Quelques variables importantes
"""global user
user = 0"""
nbfilm = 0

class Window1(SimpleGladeApp):

    def __init__(self, path=os.path.dirname(os.path.realpath(__file__))+"/gui.glade",
                 root="window1",
                 domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

    #-- Window1.new {
    def new(self):
	self.user = 0
	FonctionsDeBases.CommandesGeneriques()
        self.scrolledwindow4.hide()
	self.button25.hide()
	Mediatheque.Load(self, Options.ObtenirLaConfiguration(1))
	if Options.ObtenirLaConfiguration(1) == "genre":
		self.genre1.set_active(True)
		self.realisateur1.set_active(False)
		self.annee_de_sortie1.set_active(False)
		self.note1.set_active(False)
	if Options.ObtenirLaConfiguration(1) == "real":
		self.genre1.set_active(False)
		self.realisateur1.set_active(True)
		self.annee_de_sortie1.set_active(False)
		self.note1.set_active(False)
	if Options.ObtenirLaConfiguration(1) == "ann":
		self.genre1.set_active(False)
		self.realisateur1.set_active(False)
		self.annee_de_sortie1.set_active(True)
		self.note1.set_active(False)
	if Options.ObtenirLaConfiguration(1) == "note":
		self.genre1.set_active(False)
		self.realisateur1.set_active(False)
		self.annee_de_sortie1.set_active(False)
		self.note1.set_active(True)

	completion = gtk.EntryCompletion()
	self.entry2.set_completion(completion)
	completion_model = self.__create_completion_model()
	completion.set_model(completion_model)
	completion.set_text_column(0)

	#####
	##Traduction des textes GLADE
	#####
	self.label47.set_text(translation.GetTranslationValueByEntry("txt34"))
	self.label48.set_text(translation.GetTranslationValueByEntry("txt35"))
	self.label131.set_text(translation.GetTranslationValueByEntry("txt36"))
	self.label7.set_text(translation.GetTranslationValueByEntry("txt24"))
	self.label31.set_text(translation.GetTranslationValueByEntry("txt27"))
	self.label32.set_text(translation.GetTranslationValueByEntry("txt39"))
	self.label33.set_text(translation.GetTranslationValueByEntry("txt25"))
	self.label49.set_text(translation.GetTranslationValueByEntry("txt39"))
	self.label50.set_text(translation.GetTranslationValueByEntry("txt25"))
	self.label51.set_text(translation.GetTranslationValueByEntry("txt41"))
	self.label52.set_text(translation.GetTranslationValueByEntry("txt24"))
	self.window1.set_title(translation.GetTranslationValueByEntry("txt42"))
	self.importer_un_dossier1.get_child().set_label(translation.GetTranslationValueByEntry("txt43"))
	self.importer_un_fichier1.get_child().set_label(translation.GetTranslationValueByEntry("txt49"))
	self.remettre_a_zero1.get_child().set_label(translation.GetTranslationValueByEntry("txt44"))
	self.options1.get_child().set_label(translation.GetTranslationValueByEntry("txt45"))
	self.afficher_les_films_par1.get_child().set_label(translation.GetTranslationValueByEntry("txt46"))
	self.genre1.get_child().set_label(translation.GetTranslationValueByEntry("txt24"))
	self.realisateur1.get_child().set_label(translation.GetTranslationValueByEntry("txt25"))
	self.annee_de_sortie1.get_child().set_label(translation.GetTranslationValueByEntry("txt26"))
	self.note1.get_child().set_label(translation.GetTranslationValueByEntry("txt27"))
	self.affichage_par_liste1.get_child().set_label(translation.GetTranslationValueByEntry("txt47"))
	self.menuitem4.get_child().set_label(translation.GetTranslationValueByEntry("txt48"))
	#####

	#if Options.ObtenirLaConfiguration(7) == "avance":
	#	self.nouveau()
    #-- Window1.new }

    #-- Window1 custom methods {
    def userfriendly(self, a):
	Options.SauvegardeLeType("avance")
	Mediatheque.Load(self, Options.ObtenirLaConfiguration(1))

    def selectone(self, a, b ,c, d):
	(modele, iter) = self.treeview.get_selection().get_selected()
	name = modele.get_value(iter, 0).replace("<b>","",1).replace("</b>","",1)
	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("select * from films where nom = %s", (name))
	for row in cur.fetchall():
		self.AfficheFicheFilm(name)
	cur.close()
	cx.close()

    def __create_completion_model(self):
	store = gtk.ListStore(str)
	
	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("select * from films")
	for row in cur.fetchall():
		iter = store.append()
		store.set(iter, 0, row.nom)
	cur.close()
	cx.close()

	return store
    #-- Window1 custom methods }

    #-- Window1.on_window1_destroy {
    def on_window1_destroy(self, widget, *args):
	gtk.main_quit()
	return False
    #-- Window1.on_window1_destroy }

    #-- Window1.on_importer_un_dossier1_activate {
    def on_importer_un_dossier1_activate(self, widget, *args):
        Mediatheque.AjouteDossier(self)
    #-- Window1.on_importer_un_dossier1_activate }

    #-- Window1.on_importer_un_fichier1_activate {
    def on_importer_un_fichier1_activate(self, widget, *args):
        Mediatheque.AjouteFichier(self)
    #-- Window1.on_importer_un_fichier1_activate }

    #-- Window1.on_quitter1_activate {
    def on_quitter1_activate(self, widget, *args):
	gtk.main_quit()
	return False
    #-- Window1.on_quitter1_activate }

    #-- Window1.on_préférences1_activate {
    def on_preferences1_activate(self, widget, *args):
        window4 = Window4()
    #-- Window1.on_préférences1_activate }

    #-- Window1.on_genre1_activate {
    def on_genre1_activate(self, widget, *args):
	if self.genre1.get_active() == True:
		Mediatheque.Load(self, "genre")
		self.genre1.set_active(True)
		self.realisateur1.set_active(False)
		self.annee_de_sortie1.set_active(False)
		self.note1.set_active(False)
    #-- Window1.on_genre1_activate }

    #-- Window1.on_réalisateur1_activate {
    def on_realisateur1_activate(self, widget, *args):
	if self.realisateur1.get_active() == True:
		Mediatheque.Load(self, "real")
		self.genre1.set_active(False)
		self.realisateur1.set_active(True)
		self.annee_de_sortie1.set_active(False)
		self.note1.set_active(False)
    #-- Window1.on_réalisateur1_activate }

    #-- Window1.on_année_de_sortie1_activate {
    def on_annee_de_sortie1_activate(self, widget, *args):
	if self.annee_de_sortie1.get_active() == True:
		Mediatheque.Load(self, "ann")
		self.genre1.set_active(False)
		self.realisateur1.set_active(False)
		self.annee_de_sortie1.set_active(True)
		self.note1.set_active(False)
    #-- Window1.on_année_de_sortie1_activate }

    #-- Window1.on_note1_activate {
    def on_note1_activate(self, widget, *args):
	if self.note1.get_active() == True:
		Mediatheque.Load(self, "note")
		self.genre1.set_active(False)
		self.realisateur1.set_active(False)
		self.annee_de_sortie1.set_active(False)
		self.note1.set_active(True)
    #-- Window1.on_note1_activate }

    #-- Window1.on_a_propos1_activate {
    def on_a_propos1_activate(self, widget, *args):
        aboutdialog1 = Aboutdialog1()
    #-- Window1.on_a_propos1_activate }

    #-- Window1.on_remettre_a_zero1_activate {
    def on_remettre_a_zero1_activate(self, widget, *args):
	dialog = gtk.Dialog(translation.GetTranslationValueByEntry("txt4"), None, 0,(gtk.STOCK_OK,gtk.RESPONSE_OK,gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL))
	hbox = gtk.HBox(False, 8)
	hbox.set_border_width(8)
 	dialog.vbox.pack_start(hbox, False, False, 0)

	stock = gtk.image_new_from_stock(
		gtk.STOCK_DIALOG_QUESTION,
		gtk.ICON_SIZE_DIALOG)
	hbox.pack_start(stock, False, False, 0)

	label = gtk.Label(translation.GetTranslationValueByEntry("txt5"))
	hbox.pack_start(label, False, False, 0)

	dialog.show_all()

	reponse = dialog.run()

	if reponse == gtk.RESPONSE_OK:
		os.remove("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt6"))
		msgbox.run()
		msgbox.destroy()
		gtk.main_quit()
		return False

	dialog.destroy()
    #-- Window1.on_remettre_a_zero1_activate }

    #-- Window1.on_button5_clicked {
    def on_button5_clicked(self, widget, *args):
	if Options.ObtenirLaConfiguration(7) == "avance":
		self.user = 0
		self.scrolled_window.hide()

        self.scrolledwindow4.show()
	self.scrolledwindow2.hide()
	self.scrolledwindow3.hide()
	self.button25.show()
	Mediatheque.Cherche(self, self.entry2.get_text())
    #-- Window1.on_button5_clicked }

    #-- Window1.on_button25_clicked {
    def on_button25_clicked(self, widget, *args):
        self.scrolledwindow4.hide()
	self.scrolledwindow2.show()
	self.scrolledwindow3.show()
	self.button25.hide()
	self.entry2.set_text("")

	if Options.ObtenirLaConfiguration(7) == "avance":
		self.user = 0
		self.scrolled_window.hide()
		Options.SauvegardeLeType("normal")
		Mediatheque.Load(self, Options.ObtenirLaConfiguration(1))
    #-- Window1.on_button25_clicked }

    #-- Window1.on_clist1_select_row {
    def on_clist1_select_row(self, b, c, d, e):
        #Mediatheque.Load(self, Options.ObtenirLaConfiguration(1))
	if Options.ObtenirLaConfiguration(1) == "genre":
		data = Options.ObtenirTousLesGenres()
		cat = c
		cat = data[c]
		self.statusbar1.push(1,translation.GetTranslationValueByEntry("txt7").replace("%s",cat,1))
		self.clist2.clear()
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select * from films where genre = %s order by nom", (cat))
		for row in cur.fetchall():
			data2 = [ [ row.note+"/10", row.nom, row.realisateur ] ]
			self.clist2.append(data2[0])
		cur.close()
		cx.close()

	if Options.ObtenirLaConfiguration(1) == "real":
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select realisateur from films group by realisateur order by realisateur")
		i = 0
		for row in cur.fetchall():
			if c == i:
				cat = row.realisateur
			i = i + 1
		cur.close()
		cx.close()

		self.statusbar1.push(1,translation.GetTranslationValueByEntry("txt8").replace("%s",cat,1))
		self.clist2.clear()
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select * from films where realisateur = %s order by nom", (cat))
		for row in cur.fetchall():
			data2 = [ [ row.note+"/10", row.nom, row.realisateur ] ]
			self.clist2.append(data2[0])
		cur.close()
		cx.close()

	if Options.ObtenirLaConfiguration(1) == "ann":
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select annee from films group by annee order by annee")
		i = 0
		for row in cur.fetchall():
			if c == i:
				cat = row.annee
			i = i + 1
		cur.close()
		cx.close()

		self.statusbar1.push(1,translation.GetTranslationValueByEntry("txt9").replace("%s",cat,1))
		self.clist2.clear()
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select * from films where annee = %s order by nom", (cat))
		for row in cur.fetchall():
			data2 = [ [ row.note+"/10", row.nom, row.realisateur ] ]
			self.clist2.append(data2[0])
		cur.close()
		cx.close()

	if Options.ObtenirLaConfiguration(1) == "note":
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select note from films group by note order by note")
		i = 0
		for row in cur.fetchall():
			if c == i:
				cat = row.note
			i = i + 1
		cur.close()
		cx.close()

		self.statusbar1.push(1,translation.GetTranslationValueByEntry("txt10").replace("%s",cat,1))
		self.clist2.clear()
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select * from films where note = %s order by nom", (cat))
		for row in cur.fetchall():
			data2 = [ [ row.note+"/10", row.nom, row.realisateur ] ]
			self.clist2.append(data2[0])
		cur.close()
		cx.close()
    #-- Window1.on_clist1_select_row }

    #-- Window1.on_clist2_select_row {
    def on_clist2_select_row(self, b, c, d, e):
	self.AfficheFicheFilm(self.clist2.get_text(c,1))
    #-- Window1.on_clist2_select_row }

    #-- Window1.on_clist3_select_row {
    def on_clist3_select_row(self, b, c, d, e):
        self.AfficheFicheFilm(self.clist3.get_text(c,0))
    #-- Window1.on_clist3_select_row }

    def AfficheFicheFilm(self, nomdufilm):
	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("select * from films where nom = %s limit 1", (nomdufilm))
	for row in cur.fetchall():

		global nbfilm
		if nbfilm == 0:

			global fichierencours
			global nomdufilmencours
			nomdufilmencours = nomdufilm
			fichierencours = row.fichier

			window2 = Window2()

			window2.window2.set_title(nomdufilm)

			window2.label169.set_markup("<big><b>"+nomdufilm+"</b></big>")
			window2.label170.set_markup("<big><i>"+row.realisateur+"</i></big>")
			variable2 = translation.GetTranslationValueByEntry("txt11")
			variable = variable2.replace("%x",row.annee,1).replace("%s",row.note,1)
			window2.label172.set_markup("<b>"+variable+"</b>")

			window2.textview6.set_wrap_mode(gtk.WRAP_WORD)
			buffertexte = window2.textview6.get_buffer()
			buffertexte.set_text(row.url)
	
			window2.image92.set_from_file(row.imagemedium)

			window2.entry18.set_text(nomdufilm)
			window2.entry19.set_text(row.realisateur)
			window2.entry20.set_text(row.annee)
			window2.combobox8.set_active(0)

			window2.textview7.set_wrap_mode(gtk.WRAP_WORD)
			buffertexte = window2.textview7.get_buffer()
			buffertexte.set_text(row.url)

			window2.combobox7.set_active(0)

		else:
			msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt12"))
			msgbox.run()
			msgbox.destroy()
	cur.close()
	cx.close()

class Window2(SimpleGladeApp):

    def __init__(self, path="gui.glade",root="window2",domain=app_name, **kwargs):
	path = os.path.join(glade_dir, path)
	SimpleGladeApp.__init__(self, path, root, domain, **kwargs)
	global nbfilm
	nbfilm = 1
	#####
	##Traduction des textes GLADE
	#####
	self.label168.set_markup(translation.GetTranslationValueByEntry("txt50"))
	self.label166.set_text(translation.GetTranslationValueByEntry("txt50").replace("<b>","",1).replace("</b>","",1))
	self.label167.set_text(translation.GetTranslationValueByEntry("txt45").replace("_","",1))
	self.label173.set_text(translation.GetTranslationValueByEntry("txt38"))
	self.label174.set_text(translation.GetTranslationValueByEntry("txt40"))
	self.label175.set_text(translation.GetTranslationValueByEntry("txt52"))
	self.label184.set_text(translation.GetTranslationValueByEntry("txt39"))
	self.label185.set_text(translation.GetTranslationValueByEntry("txt25"))
	self.label186.set_text(translation.GetTranslationValueByEntry("txt26"))
	self.label187.set_text(translation.GetTranslationValueByEntry("txt24"))
	self.label188.set_markup(translation.GetTranslationValueByEntry("txt37"))
	self.label176.set_markup(translation.GetTranslationValueByEntry("txt53"))
	self.label183.set_markup(translation.GetTranslationValueByEntry("txt54"))
	self.label182.set_text(translation.GetTranslationValueByEntry("txt55"))
	self.label177.set_markup(translation.GetTranslationValueByEntry("txt56"))
	self.label180.set_markup(translation.GetTranslationValueByEntry("txt57"))
	self.label181.set_text(translation.GetTranslationValueByEntry("txt56").replace("<b>","",1).replace("</b>","",1))
	self.label178.set_markup(translation.GetTranslationValueByEntry("txt58"))
	self.label179.set_markup(translation.GetTranslationValueByEntry("txt59"))
	#####

    def on_window2_destroy(self, widget, *args):
	global nbfilm
	nbfilm = 0

    def on_button41_clicked(self, widget, *args):
	dialog = gtk.Dialog(translation.GetTranslationValueByEntry("txt13"), None, 0,(gtk.STOCK_OK,gtk.RESPONSE_OK,gtk.STOCK_CANCEL,gtk.RESPONSE_CANCEL))
	hbox = gtk.HBox(False, 8)
	hbox.set_border_width(8)
 	dialog.vbox.pack_start(hbox, False, False, 0)

	stock = gtk.image_new_from_stock(
		gtk.STOCK_DIALOG_QUESTION,
		gtk.ICON_SIZE_DIALOG)
	hbox.pack_start(stock, False, False, 0)

	label = gtk.Label(translation.GetTranslationValueByEntry("txt14").replace("%s",nomdufilmencours,1))
	hbox.pack_start(label, False, False, 0)

	dialog.show_all()

	reponse = dialog.run()

	if reponse == gtk.RESPONSE_OK:
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("delete from films where fichier = %s ", (fichierencours))
		cx.commit()
		cur.close()
		cx.close()
		variable2 = translation.GetTranslationValueByEntry("txt15")
		variable = variable2.replace("%x",nomdufilmencours,1).replace("%s",fichierencours,1)
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,variable)
		msgbox.run()
		msgbox.destroy()
		self.window2.destroy()

	dialog.destroy()

    def on_button42_clicked(self, widget, *args):
	self.selectfichier = gtk.FileChooserDialog(translation.GetTranslationValueByEntry("txt16"), None, gtk.FILE_CHOOSER_ACTION_OPEN, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
	self.selectfichier.set_current_folder(os.path.expanduser("~/"))
	filter = gtk.FileFilter()
	filter.add_pattern("*.gif")
	filter.add_pattern("*.png")
	filter.add_pattern("*.jpg")
	filter.add_pattern("*.jpeg")
	self.selectfichier.set_filter(filter)
	dossier2 = gtk.FileChooserDialog.run(self.selectfichier)
        fichier = None
        if dossier2 == gtk.RESPONSE_OK:
		fichier = self.selectfichier.get_filename()
       	self.selectfichier.destroy()
	if fichier != None:
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("update films set imagemedium = %s where fichier = %s ", (fichier, fichierencours))
		cx.commit()
		cur.close()
		cx.close()
	self.image92.set_from_file(fichier)

    def on_button43_clicked(self, widget, *args):
	note = self.combobox7.get_active_text()
	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("update films set note = %s where fichier = %s ", (note, fichierencours))
	cx.commit()
	cur.close()
	cx.close()

    def on_button44_clicked(self, widget, *args):
	buffertexte = self.textview7.get_buffer()
	texte1 = buffertexte.get_text(buffertexte.get_start_iter(),buffertexte.get_end_iter())
	texte2 = texte1.replace('"', '\"')
	longtxt = texte2.replace("'", "\'")

	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("update films set url = %s where fichier = %s ", (longtxt, fichierencours))
	cx.commit()
	cur.close()
	cx.close()

	msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt17"))
	msgbox.run()
	msgbox.destroy()

    def on_button45_clicked(self, widget, *args):
	nom_film = self.entry18.get_text()
	realisateur_film = self.entry19.get_text()
	annee_film = self.entry20.get_text()
	genre_film = self.combobox8.get_active_text()

	if nom_film == "":
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt18"))
		msgbox.run()
		msgbox.destroy()
		return False
	if realisateur_film == "":
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt18"))
		msgbox.run()
		msgbox.destroy()
		return False
	if annee_film == "":
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt18"))
		msgbox.run()
		msgbox.destroy()
		return False
	if genre_film == "":
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt18"))
		msgbox.run()
		msgbox.destroy()
		return False

	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("update films set nom = %s, realisateur = %s, annee = %s, genre = %s where fichier = %s ", (nom_film, realisateur_film, annee_film, genre_film, fichierencours))
	cx.commit()
	cur.close()
	cx.close()

	msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_INFO,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt19"))
	msgbox.run()
	msgbox.destroy()

    def on_button40_clicked(self, widget, *args):
	fileto = fichierencours.replace("'","\\'",50)
	commands.getoutput(Options.ObtenirLaConfiguration(4)+" "+fileto.replace(' ','\ ',50))

class Aboutdialog1(SimpleGladeApp):

    def __init__(self, path="gui.glade",
                 root="aboutdialog1",
                 domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

class Window4(SimpleGladeApp):

    def __init__(self, path="gui.glade",
                 root="window4",
                 domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

    #-- Window4.new {
    def new(self):
	if Options.ObtenirLaConfiguration(2) == "dvd":
		self.combobox2.set_active(0)
	if Options.ObtenirLaConfiguration(2) == "vhs":
		self.combobox2.set_active(1)
	if Options.ObtenirLaConfiguration(2) == "video":
		self.combobox2.set_active(2)

	self.combobox3.remove_text(0)
	self.combobox3.insert_text(0,translation.GetTranslationValueByEntry("txt83"))
	self.combobox3.insert_text(1,translation.GetTranslationValueByEntry("txt84"))
	self.combobox3.insert_text(2,translation.GetTranslationValueByEntry("txt85"))

	if Options.ObtenirLaConfiguration(3) == "Grande":
		self.combobox3.set_active(0)
	if Options.ObtenirLaConfiguration(3) == "Moyenne":
		self.combobox3.set_active(1)
	if Options.ObtenirLaConfiguration(3) == "Petite":
		self.combobox3.set_active(2)

	self.entry11.set_text(Options.ObtenirLaConfiguration(4))

	self.combobox9.remove_text(0)
	for n in glob.glob(os.path.dirname(os.path.realpath(__file__))+"/lang/translate-*.xml"):
		i = 0
		for o in re.findall('/lang/translate-(.*?).xml',n):
			self.combobox9.insert_text(i,o)
			i = i + 1
		self.combobox9.set_active(0)

	if Options.ObtenirLaConfiguration(5) == "oui":
		self.checkbutton1.set_active(True)
		self.label122.set_sensitive(True)
		self.label123.set_sensitive(True)
		self.combobox2.set_sensitive(True)
		self.combobox3.set_sensitive(True)
	else:
		self.label122.set_sensitive(False)
		self.label123.set_sensitive(False)
		self.combobox2.set_sensitive(False)
		self.combobox3.set_sensitive(False)
	## TODO : édition des catégories
	#LOCALE = "fr"
	#fichier = open(os.path.dirname(os.path.realpath(__file__))+"/lang/rub-"+LOCALE,"r")
	#for ligne in fichier:
	#	final = [ ligne ]
	#	self.clist6.append(final)

	#####
	##Traduction des textes GLADE
	#####
	self.label108.set_text(translation.GetTranslationValueByEntry("txt60"))
	self.label109.set_text(translation.GetTranslationValueByEntry("txt61"))
	self.label193.set_text(translation.GetTranslationValueByEntry("txt51"))
	self.label115.set_markup(translation.GetTranslationValueByEntry("txt62"))
	self.label120.set_text(translation.GetTranslationValueByEntry("txt63"))
	self.label121.set_markup(translation.GetTranslationValueByEntry("txt64"))
	self.checkbutton1.set_label(translation.GetTranslationValueByEntry("txt65"))
	self.label122.set_text(translation.GetTranslationValueByEntry("txt66"))
	self.label123.set_text(translation.GetTranslationValueByEntry("txt67"))
	self.label194.set_markup(translation.GetTranslationValueByEntry("txt68"))
	self.label195.set_text(translation.GetTranslationValueByEntry("txt69"))
	self.label106.set_text(translation.GetTranslationValueByEntry("txt70"))
	self.label107.set_text(translation.GetTranslationValueByEntry("txt71"))
	#####
    #-- Window4.new }

    #-- Window4.on_button20_clicked {
    def on_button20_clicked(self, widget, *args):
	self.window4.destroy()
    #-- Window4.on_button20_clicked }

    #-- Window4.on_checkbutton1_clicked {
    def on_checkbutton1_clicked(self, widget, *args):
	#if self.label122.get_sensitive() == True:
	if self.label122.get_property('sensitive') == 1:
		self.label122.set_sensitive(False)
		self.label123.set_sensitive(False)
		self.combobox2.set_sensitive(False)
		self.combobox3.set_sensitive(False)
	else:
		self.label122.set_sensitive(True)
		self.label123.set_sensitive(True)
		self.combobox2.set_sensitive(True)
		self.combobox3.set_sensitive(True)
    #-- Window4.on_checkbutton1_clicked }

    #-- Window4.on_button49_clicked {
    def on_button49_clicked(self, widget, *args):
	webbrowser.open("http://www.cucumis.org/projet_0_p/projet_v_35.html")
    #-- Window4.on_button49_clicked }

    #-- Window4.on_button21_clicked {
    def on_button21_clicked(self, widget, *args):
        ligne = self.combobox2.get_active_text()
        taille2 = self.combobox3.get_active()
	if taille2 == 0:
		taille = "Grande"
	if taille2 == 1:
		taille = "Moyenne"
	if taille2 == 2:
		taille = "Petite"
	
	if self.radiobutton1.get_active() == True:
		video = "totem"
	if self.radiobutton2.get_active() == True:
		video = "vlc"
	if self.radiobutton3.get_active() == True:
		video = "mplayer"
	if self.radiobutton4.get_active() == True:
		video = "realplay"
	if self.radiobutton5.get_active() == True:
		video = self.entry11.get_text()

	config = ConfigParser.ConfigParser()

	config.add_section("divers")
	config.set("divers", "locale", self.combobox9.get_active_text())
	if self.checkbutton1.get_active() == True:
		config.set("divers", "pochette", "oui")
	else:
		config.set("divers", "pochette", "non")
	config.set("divers", "type", Options.ObtenirLaConfiguration(7))

	config.add_section("mediatheque")
	config.set("mediatheque", "typeof", Options.ObtenirLaConfiguration(1))

	config.add_section("film")
	config.set("film", "prog", video)

	config.add_section("amazon")
	config.set("amazon", "ligne", ligne)
	config.set("amazon", "taille", taille)

	config.write(open("/home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg","w"))
	self.window4.destroy()
    #-- Window4.on_button21_clicked }

#-- main {

def main():
    window1 = Window1()
    window1.run()

if __name__ == "__main__":
    main()

#-- main }
